*This repository is part of the outcomes of the Specialist Task Force 620 focusing on the authoring of a World Representation as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation authoring components includes:*

*•	The C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# Description - Version for STF 669

This repo should be used to construct a complete ASP-Net REST server compliant to the ARF World Storage API. It uses auto-generated ASP.NET server code. We propose to use the open source OpenAPI-Generator for this.

It includes description and code for a fully functional server with MongoDB integration.

## Repo Content

|   |  Files / Folders |                                                                                    Description                                                                                    |
|:-:|:--------------:|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 📂 | openapi         | A git submodule (ForgeETSI ) pointing to the repo containing the API specification file                                                                                                |
| 📂 | server  | The folder where the library code will be generated, the openapi generator is set to not overwrite some files used to generate and initialiue the ASP.Net server system |
| 📂 | server/worldstorage/src/ETSI.ARF.OpenAPI.WorldStorage | This is the location where the ASP.Net code will be generated |
| 📂 | server/worldstorage/src/ETSI.ARF.OpenAPI.WorldStorage/ETSI-ARF | This folder contains codes implementating the REST end-paths for the different objects in API |
| 📂 | server/programs/MongoDB | This folder contains the MongoDB service. The World Storage database should be created or imported in a folder of your choice which path has to be editied in the .bat file |
| 📂 | server\worldstorage\src\ETSI.ARF.OpenAPI.WorldStorage\appsettings.json | Parameter for accessing the MongoDB server from the ASP.NET services. This file contains the MongoDB server IP and optional port number, name of the World Storage database and their collections. |

## Requirements

What you need:

1.	Installed npm: https://phoenixnap.com/kb/install-node-js-npm-on-windows
2.	Installed openapi generator with npm: https://openapi-generator.tech/docs/installation/
3.	Installed docker (recommanded): https://www.docker.com/get-started 

# Code Generation

We provide the file `.openapi-generator-ignore` in `server`, which prevents openapi-generator to override some adapted files.

## Auto-generate server code

Use/define following setup for the config file `openapitools.json`:

```
{
  "$schema": "node_modules/@openapitools/openapi-generator-cli/config.schema.json",
  "spaces": 2,
  "generator-cli": {
    "version": "5.3.0",
    "generators":{
      "v1.1": {
     "generatorName": "aspnetcore",
     "output": "./server/worldstorage",
     "inputSpec": "./openapi/API/worldstorage/worldstorageopenapi.yaml",
     "additionalProperties": {
       "aspnetCoreVersion": "5.0",
       "packageName": "ETSI.ARF.OpenAPI.WorldStorage",
       "operationModifier": "abstract",
       "classModifier": "abstract"
      }
    }
    }
  }
}
```

Open a command shell and execute:
```
  npx openapi-generator-cli generate
```

Open the solution `ETSI.ARF.OpenAPI.WorldStorage.sln` (folder `server/worldstorage`) in Visual Studio:

## In Visual Studio
Open `NuGet Package Manager` and add `MongoDB.Driver`.

### File adaptations
Change version number in all files if a new version is provided.

## 📂 Custom folders (new)
All custom files are now in the folder 'ETSI-ARF'. Nothing to do adapt manually after generation. But you have to provide the implementation of new endpoints because they are now directly declared as abstract (default).

The folder contains following subfolders:
`ControllersImpl`
`ModelsExt`
`Services`

### 📂 Folder 'ControllersImp'

The modules in this folder implement the endpoints. Compare files folder in "`ETSI-ARF/ControllersImpl`" with the corresponding files in "`Controllers`" and implement if necessary the new methods.

Methods should be the same with "`override`" instead of "`abstract`".

--- 

#### If some files are missing (and only then!)
Add 
```
  using MongoDB.Driver;
```

Add one or more private readonly services class variable like in the already existing files, e.g.:
```
private readonly TrackableService _trackableService;
private readonly WorldAnchorService _worldAnchorService;
private readonly WorldLinkService _worldLinkService;
```

Add a constructor with this service class variable like in the already existing files.
```
public TrackablesApiControllerImpl(TrackableService trackableService)
{
    _trackableService = trackableService;
    // etc.
}
```

Implement endpoint code using the appropriate MongoDB methods of the corresponding classes from the folder `Services` (which you may be have to create).

### 📂 Folder `ModelsExt`
The modules inside this folder are for extensions of the generated API data structures. Add all the classes to be stored in the database (i.e. `TrackableExt.cs`, `WorldAnchorExt.cs`, `WorldLinkExt.cs`) inherited from `IModels`. (definition of the extra UUID): 
```
  using MongoDB.Bson;
  using MongoDB.Bson.Serialization.Attributes;
```

and at the value that is to become the MongoDB ID, add:
```
  [BsonId]
  [BsonRepresentation(BsonType.String)]
```

If some members won't be saved in the MongoDB then use this keyword:
```
[BsonIgnore]
```

### 📂 Folder `Services`
The folder `Services` is for handling the data with the MongoDB. It should contain one common class with the DatabaseSettings (`DatabaseSettings.cs`) and one with the database-access-methods (create, get, update, remove) for each API. If some are missing create them like the ones you find there. Be aware to add the reference to these in the file `startup.cs` in this case.

The naming in the DatabaseSettings is the same as defined in `appsettings.json`, which you have to extend when creating new classes in this folder. Change `appsettings.json` in the folder `docker` accordingly. Make sure that the ConnectionString for the database contains the correct IP address as specified in `docker-compose.yml`.

## 📂 Extra folder `wwwroot`
Add in `openapi-original.json` in section `servers` the urls of the servers you want to use with swagger-ui

# MongoDB
If you don't have a MongoDB, follow the instructions in `readme.md` in `server/programs/MongoDB` 

...and put MongoDB in folder `server/programs/MongoDB` (download MongoDB as zip-file from https://www.mongodb.com/try/download/community and unzip the file into this directory, so that the bin-directory is in this folder).

To setup MongoDB in the IIS webserver, adjust the parameters in the file `appsettings.json`. Default values for the databes an collections are:

    "DatabaseName": "WorldStorageAPI",
    "CollectionNameWorldLinks": "WorldLinks",
    "CollectionNameTrackables": "Trackables",
    "CollectionNameWorldAnchors": "WorldAnchors"

Set the correct server IP/adress and port number (if there is one). Use the network setup as you define in the Docker-Compose yaml file, e.g. 
``` 
    ports:
      - 27037:27017                   // mapping, for accessing the MongoDB from outside
      - 27038:27018
    networks:
      vpcbr:
        ipv4_address: 172.24.30.101   // or whatever you want
``` 
Server settings:

    "MongoSrv": "172.24.30.101",      // same as defined in the yaml file
    "MongoPort": "27017",             // internal docker port

## How to dump database 
Execute the following command in docker:
``` 
  mongodump --db **insert database_name** --out /data-dump/`date +"%Y-%m-%d"`
```

## How to import database
Execute the following command in docker:
```
  mongorestore --db **insert database_name** **insert path_to_bson_file**
```

# Use in Visual Studio
Make sure, that an instance of MongoDB is running.

Start application with IIS Express.


# Use API within a Docker

## Creating the IIS docker ##
Remove the substring `src/Org.OpenAPITools/` in Dockerfile (if not already done)

open a command shell and generate docker by executing:
```
  build-iis-docker-ws.bat
```

## How to start (with Docker-Compose)
The easiest way is to use docker-compose:

Open a command shell and use docker-compose (if necessary adapt docker-compose.yml) by executing`:
```
  docker-compose.bat
```

Open http://localhost:8080/openapi/index.html in a web-browser, if you want to check the functionalities using SwaggerUI

## How to stop
Open a command shell by executing in `server/worldstorage/src/ETSI.ARF.OpenAPI.WorldStorage`:
```
  docker-compose down
```
