/*
 * SmartSite Core System API
 *
 * API ensuring interoperability between the various services, tools and apps in SmartSite
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Net;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Attributes;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using ETSI.ARF.OpenAPI.WorldStorage.Services;

namespace ETSI.ARF.OpenAPI.WorldStorage.Controllers
{
#pragma warning disable CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element
    /// <summary>
    /// 
    /// </summary>
    public class DefaultApiControllerExt : DefaultApiController
    {
        public override IActionResult GetPing()
        {
            string answer = "Pong";
            return new ObjectResult(answer);
        }

        public override IActionResult GetAdmin()
        {
            string answer = "ETSI ARF Server Running.";
            return new ObjectResult(answer);
        }

        public override IActionResult GetVersion()
        {
            string answer = "ETSI ARF RESTful API 1.0.1";
            return new ObjectResult(answer);
        }

        [NonAction]
        private string writeMsg(string title, string msg)
        {
            return $"<p>{title}: \t {msg}</p>";
        }

        [NonAction]
        public /*override*/ IActionResult GetReport()
        {
            string projectName = "ETSI ARF - STF 620";
            string machinename = System.Environment.MachineName;
            string hostname = Dns.GetHostName();
            var ips = Dns.GetHostAddresses(hostname);

            string status = "Running";
            string mongoStatus = "Running";
            //string mongoCollectionUsers = "Number = " + UserService.Singleton?.NumOfDocuments();
            //string mongoCollectionMachines = "Number = " + MachineService.Singleton?.NumOfDocuments();
            //string mongoCollectionAssets = "Number = " + AssetService.Singleton?.NumOfDocuments();
            //string mongoCollectionJobs = "Number = " + JobService.Singleton?.NumOfDocuments();

            //List<User> users = UserService.Singleton?.Get();
            //int activeU = 0;
            //int nonActiveU = 0;
            //foreach (var u in users)
            //    if (u.IsLogged) activeU++;
            //    else nonActiveU++;

            //List<Job> jobs = JobService.Singleton?.Get();
            //int jobNum = 0;
            //foreach (var j in jobs)
            //    if (j.Progress != 100) jobNum++;

            //
            // Simple output
            //
            string html = "<!DOCTYPE html> <html>" +
                "<head>" +
                " <title>SmartSiteCloud</title>" +
                "</head>" +
                "<body>" +
                " <h1>SmartSite Cloud</h1>" +
                " <h2>Server based on IIS/ASP.NET</h1>" +
                   writeMsg("Local Date & Time:", DateTime.Now.ToLongDateString() + " " + DateTime.Now.ToLongTimeString()) +
                   writeMsg("Machine Name", machinename) + writeMsg("Host Name", hostname) + writeMsg("IPv6", ips[0].ToString()) +
                " <h3>Services</h3>" +
                   writeMsg("WebServer", status) +
                   writeMsg("MongoDB", mongoStatus) +
                   //writeMsg(" > Users", mongoCollectionUsers) +
                   //writeMsg(" > Machines", mongoCollectionMachines) +
                   //writeMsg(" > Assets", mongoCollectionAssets) +
                   //writeMsg(" > Jobs", mongoCollectionJobs) +
                " <h2>Database</h1>" +
                //" <h3>Users</h1>" +
                //   writeMsg(" - Active", activeU.ToString()) +
                //   writeMsg(" - Non active", nonActiveU.ToString()) +
                //" <h3>Jobs</h1>" +
                //   writeMsg(" - Running jobs", jobNum.ToString()) +
                "</body></html> ";

            //
            // Complex output (for RocketCake)
            //            
            // always use https
            //string domainName = (HttpContext.Request.IsHttps ? "https://" : "https://") + HttpContext.Request.Host.ToUriComponent() + "/portal"; // Ex: "https://localhost:44301/portal"
            //string root = Path.Combine(Startup.wPath, "portal");
            //string htmlFname = Path.Combine(root, "status.html");
            //string[] template = System.IO.File.ReadAllLines(htmlFname);
            //string html2 = "";

            //string msg1 =
            //   writeMsg("Domain", domainName) +
            //   writeMsg("Project", projectName) +
            //   writeMsg("Local Date", DateTime.Now.ToLongDateString() + " " + DateTime.Now.ToLongTimeString()) +
            //   writeMsg("Machine Name", machinename) + writeMsg("Host Name", hostname) + writeMsg("IPv6", ips[0].ToString());
            //string msg2 =
            //    writeMsg("WebServer", status) +
            //    writeMsg("MongoDB", mongoStatus) +
            //    //writeMsg(" > Users", mongoCollectionUsers) +
            //    //writeMsg(" > Machines", mongoCollectionMachines) +
            //    //writeMsg(" > Assets", mongoCollectionAssets) +
            //    //writeMsg(" > Jobs", mongoCollectionJobs) +
            //    writeMsg("MinIO", "-");


            //foreach (var line in template)
            //{
            //    string res = line;
            //    res = res.Replace("src=\"", "src=\"" + domainName + "/");
            //    res = res.Replace("href=\"", "href=\"" + domainName + "/");
            //    res = res.Replace("$name1$", projectName);
            //    res = res.Replace("$msg1$", msg1);
            //    res = res.Replace("$msg2$", msg2);
            //    html2 += res;
            //}

            return Content(html, "text/html");
            //return Content(html2, "text/html");
        }
    }
#pragma warning restore CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element
}
