//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Org.OpenAPITools.Models;
using MongoDB.Driver;

namespace Org.OpenAPITools.Services
{
  public class WorldLinkService
  {
    private readonly IMongoCollection<WorldLink> _worldlinkcollection;
    private readonly IMongoCollection<WorldAnchor> _worldanchorcollection;
    private readonly IMongoCollection<Trackable> _trackablecollection;

    /// <summary>
    /// 
    /// </summary>
    public WorldLinkService(IDatabaseSettings settings)
    {
      var client = new MongoClient(settings.ConnectionString);
      var database = client.GetDatabase(settings.DatabaseName);

      _worldlinkcollection = database.GetCollection<WorldLink>(settings.CollectionNameWorldLink);
      _worldanchorcollection = database.GetCollection<WorldAnchor>(settings.CollectionNameWorldAnchor);
      _trackablecollection = database.GetCollection<Trackable>(settings.CollectionNameTrackables);
    }

    public List<WorldLink> Get() =>
        _worldlinkcollection.Find(worldlink => true).ToList();

    public List<WorldLink> Get(int limit) =>
        _worldlinkcollection.Find(worldlink => true).Limit(limit).ToList();

    public WorldLink Get(Guid UUID) =>
        _worldlinkcollection.Find<WorldLink>(worldlink => worldlink.UUID == UUID).FirstOrDefault();

    public WorldLink Create(WorldLink worldlink)
    {
      _worldlinkcollection.InsertOne(worldlink);
      return worldlink;
    }

    public ReplaceOneResult Update(Guid UUID, WorldLink worldlinkIn) =>
        _worldlinkcollection.ReplaceOne(worldlink => worldlink.UUID == UUID, worldlinkIn);

    public DeleteResult Remove(WorldLink worldlinkIn) =>
        _worldlinkcollection.DeleteOne(worldlink => worldlink.UUID == worldlinkIn.UUID);

    public DeleteResult Remove(Guid UUID) =>
        _worldlinkcollection.DeleteOne(worldlink => worldlink.UUID == UUID);


    /*********************/
    public WorldAnchor GetAnchor(Guid UUID) =>
        _worldanchorcollection.Find<WorldAnchor>(worldanchor => worldanchor.UUID == UUID).FirstOrDefault();

    public Trackable GetTrackable(Guid UUID) =>
        _trackablecollection.Find<Trackable>(trackable => trackable.UUID == UUID).FirstOrDefault();

  }
}

