//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Org.OpenAPITools.Models;
using MongoDB.Driver;

namespace Org.OpenAPITools.Services
{
  public class WorldAnchorService
  {
    private readonly IMongoCollection<WorldAnchor> _worldanchorcollection;
    private readonly IMongoCollection<WorldLink> _worldlinkcollection;

    /// <summary>
    /// 
    /// </summary>
    public WorldAnchorService(IDatabaseSettings settings)
    {
      var client = new MongoClient(settings.ConnectionString);
      var database = client.GetDatabase(settings.DatabaseName);

      _worldanchorcollection = database.GetCollection<WorldAnchor>(settings.CollectionNameWorldAnchor);
      _worldlinkcollection = database.GetCollection<WorldLink>(settings.CollectionNameWorldLink);
    }

    public List<WorldAnchor> Get() =>
        _worldanchorcollection.Find(worldanchor => true).ToList();

    public List<WorldAnchor> Get(int limit) =>
        _worldanchorcollection.Find(worldanchor => true).Limit(limit).ToList();

    public WorldAnchor Get(Guid UUID) =>
        _worldanchorcollection.Find<WorldAnchor>(worldanchor => worldanchor.UUID == UUID).FirstOrDefault();

    public WorldAnchor Create(WorldAnchor worldanchor)
    {
      _worldanchorcollection.InsertOne(worldanchor);
      return worldanchor;
    }

    public ReplaceOneResult Update(Guid UUID, WorldAnchor worldanchorIn) =>
        _worldanchorcollection.ReplaceOne(worldanchor => worldanchor.UUID == UUID, worldanchorIn);

    public DeleteResult Remove(WorldAnchor worldanchorIn) =>
        _worldanchorcollection.DeleteOne(worldanchor => worldanchor.UUID == worldanchorIn.UUID);

    public DeleteResult Remove(Guid UUID) =>
        _worldanchorcollection.DeleteOne(worldanchor => worldanchor.UUID == UUID);


    /* WorldLink */
    public List<WorldLink> GetWorldLinkUUIDFrom(Guid UUID) =>
        _worldlinkcollection.Find<WorldLink>(worldlink => worldlink.UUIDFrom == UUID).ToList();

    public List<WorldLink> GetWorldLinkUUIDTo(Guid UUID) =>
        _worldlinkcollection.Find<WorldLink>(worldlink => worldlink.UUIDTo == UUID).ToList();
    public ReplaceOneResult UpdateWorldLink(Guid UUID, WorldLink worldlinkIn) =>
       _worldlinkcollection.ReplaceOne(worldlink => worldlink.UUID == UUID, worldlinkIn);
  }

}

