//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Org.OpenAPITools.Models;
using MongoDB.Driver;

namespace Org.OpenAPITools.Services
{
  public class TrackableService
  {
    private readonly IMongoCollection<Trackable> _trackablecollection;
    private readonly IMongoCollection<WorldLink> _worldlinkcollection;

    /// <summary>
    /// 
    /// </summary>
    public TrackableService(IDatabaseSettings settings)
    {
      var client = new MongoClient(settings.ConnectionString);
      var database = client.GetDatabase(settings.DatabaseName);

      _trackablecollection = database.GetCollection<Trackable>(settings.CollectionNameTrackables);
      _worldlinkcollection = database.GetCollection<WorldLink>(settings.CollectionNameWorldLink);
    }

    public List<Trackable> Get() =>
        _trackablecollection.Find(trackable => true).ToList();

    public List<Trackable> Get(int limit) =>
        _trackablecollection.Find(trackable => true).Limit(limit).ToList();

    public Trackable Get(Guid UUID) =>
        _trackablecollection.Find<Trackable>(trackable => trackable.UUID == UUID).FirstOrDefault();

    public Trackable Create(Trackable trackable)
    {
      _trackablecollection.InsertOne(trackable);
      return trackable;
    }

    public ReplaceOneResult Update(Guid UUID, Trackable trackableIn) =>
        _trackablecollection.ReplaceOne(trackable => trackable.UUID == UUID, trackableIn);

    public DeleteResult Remove(Trackable trackableIn) =>
        _trackablecollection.DeleteOne(trackable => trackable.UUID == trackableIn.UUID);

    public DeleteResult Remove(Guid UUID) =>
        _trackablecollection.DeleteOne(trackable => trackable.UUID == UUID);



    /* WorldLink */
    public List<WorldLink> GetWorldLinkUUIDFrom(Guid UUID) =>
        _worldlinkcollection.Find<WorldLink>(worldlink => worldlink.UUIDFrom == UUID).ToList();

    public List<WorldLink> GetWorldLinkUUIDTo(Guid UUID) =>
        _worldlinkcollection.Find<WorldLink>(worldlink => worldlink.UUIDTo == UUID).ToList();

    public ReplaceOneResult UpdateWorldLink(Guid UUID, WorldLink worldlinkIn) =>
         _worldlinkcollection.ReplaceOne(worldlink => worldlink.UUID == UUID, worldlinkIn);

  }

}

