//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Org.OpenAPITools.Services
{
  public class DatabaseSettings : IDatabaseSettings
  {
    public string CollectionNameWorldLink { get; set; }
    public string CollectionNameTrackables { get; set; }
    public string CollectionNameWorldAnchor { get; set; }
    public string ConnectionString { get; set; }
    public string DatabaseName { get; set; }
  }

  public interface IDatabaseSettings
  {
    string CollectionNameWorldLink { get; set; }
    string CollectionNameTrackables { get; set; }
    string CollectionNameWorldAnchor { get; set; }
    string ConnectionString { get; set; }
    string DatabaseName { get; set; }
  }
}
