//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using Org.OpenAPITools.Attributes;
using Org.OpenAPITools.Models;
using Org.OpenAPITools.Services;
using MongoDB.Driver;

namespace Org.OpenAPITools.Controllers
{
  /// <summary>
  /// 
  /// </summary>
  [ApiController]
  public class WorldLinksApiControllerImpl : WorldLinksApiController
  {

    private readonly WorldLinkService _worldLinkService;

    /// <summary>
    /// 
    /// </summary>
    public WorldLinksApiControllerImpl(WorldLinkService worldLinkService)
    {
      _worldLinkService = worldLinkService;
    }

    /// <summary>
    /// Create a World Link between elements (world anchors and/or trackables).
    /// </summary>
    /// <remarks>Create a new World Link from a json object containing all the required informations and add it to the world storage. &lt;br&gt;As a result you will get the ID of the newly created World Link.</remarks>
    /// <param name="worldLink">The link to be added to the world storage.</param>
    /// <response code="200">OK, return the UUID of the World Link defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="409">Invalid UUID, id must be a Nil value.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPost]
    [Route("/worldLinks")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("AddWorldLink")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the World Link defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 409, type: typeof(string), description: "Invalid UUID, id must be a Nil value.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult AddWorldLink([FromBody] WorldLink worldLink)
    {
      if (String.IsNullOrEmpty(worldLink.UUID.ToString()))
      {
        worldLink.UUID = Guid.NewGuid();
      }
      try
      {
        WorldLink myworldlink = _worldLinkService.Create(worldLink);
        return StatusCode(200, myworldlink.UUID.ToString());
      }
      catch (Exception e)
      {
        return StatusCode(400, e.Message);
      }
    }

    /// <summary>
    /// Delete a World Link.
    /// </summary>
    /// <remarks>Delete a single World Link stored in the world storage from its ID.</remarks>
    /// <param name="worldLinkUUID">World Link id to delete.</param>
    /// <response code="200">OK, delete successful.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpDelete]
    [Route("/worldLinks/{worldLinkUUID}")]
    [ValidateModelState]
    [SwaggerOperation("DeleteWorldLink")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, delete successful.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult DeleteWorldLink([FromRoute(Name = "worldLinkUUID")][Required] Guid worldLinkUUID)
    {
      DeleteResult answer = _worldLinkService.Remove((worldLinkUUID));
      return (answer.IsAcknowledged && answer.DeletedCount > 0) ? new ObjectResult("ok") : StatusCode(404, "Not found, could not find UUID in database.");
    }


    /// <summary>
    /// Find a World Link by its UUID.
    /// </summary>
    /// <remarks>Get a single World Link stored in the world storage from its ID.</remarks>
    /// <param name="worldLinkUUID">UUID of the World Link to retrieve.</param>
    /// <response code="200">Successful operation.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpGet]
    [Route("/worldLinks/{worldLinkUUID}")]
    [ValidateModelState]
    [SwaggerOperation("GetWorldLinkById")]
    [SwaggerResponse(statusCode: 200, type: typeof(WorldLink), description: "Successful operation.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult GetWorldLinkById([FromRoute(Name = "worldLinkUUID")][Required] Guid worldLinkUUID)
    {
      WorldLink myworldlink = _worldLinkService.Get(worldLinkUUID);
      if (null != myworldlink)
      {
        // check TypeFrom
        if (myworldlink.TypeFrom == ObjectType.TrackableEnum)
        {
          if (null == _worldLinkService.GetTrackable(myworldlink.UUIDFrom))
          {
            myworldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDFrom = Guid.Empty;
          }
        }
        else if (myworldlink.TypeFrom == ObjectType.WorldAnchorEnum)
        {
          if (null == _worldLinkService.GetAnchor(myworldlink.UUIDFrom))
          {
            myworldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDFrom = Guid.Empty;
          }
        }
        // check TypeTo
        if (myworldlink.TypeTo == ObjectType.TrackableEnum)
        {
          if (null == _worldLinkService.GetTrackable(myworldlink.UUIDTo))
          {
            myworldlink.TypeTo = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDTo = Guid.Empty;
          }
        }
        else if (myworldlink.TypeTo == ObjectType.WorldAnchorEnum)
        {
          if (null == _worldLinkService.GetAnchor(myworldlink.UUIDTo))
          {
            myworldlink.TypeTo = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDTo = Guid.Empty;
          }
        }
      }
      return (null != myworldlink) ? new ObjectResult(myworldlink) : StatusCode(404, "Not found, could not find UUID in database.");
    }

    /// <summary>
    /// Return all World Links.
    /// </summary>
    /// <remarks>Get all the World Links currently being stored in the world storage.</remarks>
    /// <response code="200">OK return all the World Links defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpGet]
    [Route("/worldLinks")]
    [ValidateModelState]
    [SwaggerOperation("GetWorldLinks")]
    [SwaggerResponse(statusCode: 200, type: typeof(List<WorldLink>), description: "OK return all the World Links defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult GetWorldLinks()
    {
      List<WorldLink> worldlinklist = _worldLinkService.Get();
      foreach (WorldLink myworldlink in worldlinklist)
      {
        // check TypeFrom
        if (myworldlink.TypeFrom == ObjectType.TrackableEnum)
        {
          if (null == _worldLinkService.GetTrackable(myworldlink.UUIDFrom))
          {
            myworldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDFrom = Guid.Empty;
          }
        }
        else if (myworldlink.TypeFrom == ObjectType.WorldAnchorEnum)
        {
          if (null == _worldLinkService.GetAnchor(myworldlink.UUIDFrom))
          {
            myworldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDFrom = Guid.Empty;
          }
        }
        // check TypeTo
        if (myworldlink.TypeTo == ObjectType.TrackableEnum)
        {
          if (null == _worldLinkService.GetTrackable(myworldlink.UUIDTo))
          {
            myworldlink.TypeTo = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDTo = Guid.Empty;
          }
        }
        else if (myworldlink.TypeTo == ObjectType.WorldAnchorEnum)
        {
          if (null == _worldLinkService.GetAnchor(myworldlink.UUIDTo))
          {
            myworldlink.TypeTo = ObjectType.NotIdentifiedEnum;
            myworldlink.UUIDTo = Guid.Empty;
          }
        }
      }
      return new ObjectResult(worldlinklist);
    }



    /// <summary>
    /// Modify a World Link.
    /// </summary>
    /// <remarks>Modify an existing World Link given a json object containing all the required informations. &lt;br&gt; **Please note that ID of the object is required in the JSON**</remarks>
    /// <param name="worldLink">The World Link to be modified in the world storage.</param>
    /// <response code="200">OK, return the UUID of the modified World Link.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPut]
    [Route("/worldLinks")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("ModifyWorldLink")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the modified World Link.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult ModifyWorldLink([FromBody] WorldLink worldLink)
    {
      ReplaceOneResult result = _worldLinkService.Update(worldLink.UUID, worldLink);
      if (result.MatchedCount == 0)
      {
        return StatusCode(404, "Not found, could not find UUID in database.");
      }
      else
      {
        return StatusCode(200, worldLink.UUID.ToString());
      }
    }
  }
}
