//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using Org.OpenAPITools.Attributes;
using Org.OpenAPITools.Models;
using Org.OpenAPITools.Services;
using MongoDB.Driver;

namespace Org.OpenAPITools.Controllers
{
  /// <summary>
  /// 
  /// </summary>
  [ApiController]
  public class WorldAnchorsApiControllerImpl : WorldAnchorsApiController
  {

    private readonly WorldAnchorService _worldAnchorService;

    /// <summary>
    /// 
    /// </summary>
    public WorldAnchorsApiControllerImpl(WorldAnchorService worldAnchorService)
    {
      _worldAnchorService = worldAnchorService;
    }


    /// <summary>
    /// Create a World Anchor.
    /// </summary>
    /// <remarks>Create a new World Anchor from a json object containing all the required informations and add it to the world storage. &lt;br&gt;As a result you will get the ID of the newly created World Anchor.</remarks>
    /// <param name="worldAnchor">The World Anchor to be added to the world storage.</param>
    /// <response code="200">OK, return the UUID of the World Anchor defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="409">Invalid UUID, id must be a Nil value.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPost]
    [Route("/worldAnchors")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("AddWorldAnchor")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the World Anchor defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 409, type: typeof(string), description: "Invalid UUID, id must be a Nil value.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult AddWorldAnchor([FromBody] WorldAnchor worldAnchor)
    {
      if (String.IsNullOrEmpty(worldAnchor.UUID.ToString()))
      {
        worldAnchor.UUID = Guid.NewGuid();
      }
      try
      {
        WorldAnchor myworldanchor = _worldAnchorService.Create(worldAnchor);
        return StatusCode(200, myworldanchor.UUID.ToString());
      }
      catch (Exception e)
      {
        return StatusCode(400, e.Message);
      }
    }

    /// <summary>
    /// Delete a World Anchor.
    /// </summary>
    /// <remarks>Delete a single World Anchor stored in the world storage from its ID.</remarks>
    /// <param name="worldAnchorUUID">World Anchor UUID to delete.</param>
    /// <response code="200">OK, delete successful.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpDelete]
    [Route("/worldAnchors/{worldAnchorUUID}")]
    [ValidateModelState]
    [SwaggerOperation("DeleteWorldAnchor")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, delete successful.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult DeleteWorldAnchor([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID)
    {
      DeleteResult answer = _worldAnchorService.Remove((worldAnchorUUID));
      // check, if used in WorldLink
      string result = "ok";
      string worldlinkinfo = "";
      List<WorldLink> worldlinklistfrom = _worldAnchorService.GetWorldLinkUUIDFrom(worldAnchorUUID);
      foreach (WorldLink worldlink in worldlinklistfrom)
      {
        worldlinkinfo += worldlink.UUID.ToString() + "; ";
        worldlink.UUIDFrom = Guid.Empty;
        worldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
        _worldAnchorService.UpdateWorldLink(worldlink.UUID, worldlink);
      }
      List<WorldLink> worldlinklistto = _worldAnchorService.GetWorldLinkUUIDTo(worldAnchorUUID);
      foreach (WorldLink worldlink in worldlinklistto)
      {
        worldlinkinfo += worldlink.UUID.ToString() + "; ";
        worldlink.UUIDTo = Guid.Empty;
        worldlink.TypeTo = ObjectType.NotIdentifiedEnum;
        _worldAnchorService.UpdateWorldLink(worldlink.UUID, worldlink);
      }
      if (worldlinkinfo.Length > 1)
      {
        result += ", but removed object was referenced in " + worldlinkinfo + " and removed there as well";
      }
      return (answer.IsAcknowledged && answer.DeletedCount > 0) ? new ObjectResult(result) : StatusCode(404, "Not found, could not find UUID in database.");
    }

    /// <summary>
    /// Find a World Anchor by its UUID.
    /// </summary>
    /// <remarks>Get a single World Anchor stored in the world storage from its ID.</remarks>
    /// <param name="worldAnchorUUID">UUID of the World Anchor to retrieve.</param>
    /// <response code="200">Successful operation.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpGet]
    [Route("/worldAnchors/{worldAnchorUUID}")]
    [ValidateModelState]
    [SwaggerOperation("GetWorldAnchorById")]
    [SwaggerResponse(statusCode: 200, type: typeof(WorldAnchor), description: "Successful operation.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult GetWorldAnchorById([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID)
    {
      WorldAnchor myworldanchor = _worldAnchorService.Get(worldAnchorUUID);
      return (null != myworldanchor) ? new ObjectResult(myworldanchor) : StatusCode(404, "Not found, could not find UUID in database.");
    }

    /// <summary>
    /// Return all the World Anchors.
    /// </summary>
    /// <remarks>Get all the World Anchors currently being stored in the world storage.</remarks>
    /// <response code="200">OK, return all the World Anchors defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpGet]
    [Route("/worldAnchors")]
    [ValidateModelState]
    [SwaggerOperation("GetWorldAnchors")]
    [SwaggerResponse(statusCode: 200, type: typeof(List<WorldAnchor>), description: "OK, return all the World Anchors defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult GetWorldAnchors()
    {
      List<WorldAnchor> worldanchorlist = _worldAnchorService.Get();
      return new ObjectResult(worldanchorlist);
    }



    /// <summary>
    /// Modify a World Anchor.
    /// </summary>
    /// <remarks>Modify an existing World Anchor given a json object containing all the required informations. &lt;br&gt; **Please note that ID of the object is required in the JSON**</remarks>
    /// <param name="worldAnchor">The World Anchor to be modified in the world storage.</param>
    /// <response code="200">OK, return the UUID of the modified World Anchor.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPut]
    [Route("/worldAnchors")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("ModifyWorldAnchor")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the modified World Anchor.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult ModifyWorldAnchor([FromBody] WorldAnchor worldAnchor)
    {
      ReplaceOneResult result = _worldAnchorService.Update(worldAnchor.UUID, worldAnchor);
      if (result.MatchedCount == 0)
      {
        return StatusCode(404, "Not found, could not find UUID in database.");
      }
      else
      {
        return StatusCode(200, worldAnchor.UUID.ToString());
      }
    }


  }
}
