//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using Org.OpenAPITools.Attributes;
using Org.OpenAPITools.Models;
using Org.OpenAPITools.Services;
using MongoDB.Driver;

namespace Org.OpenAPITools.Controllers
{
  /// <summary>
  /// 
  /// </summary>
  [ApiController]
  public class TrackablesApiControllerImpl : TrackablesApiController
  {

    private readonly TrackableService _trackableService;

    /// <summary>
    /// 
    /// </summary>
    public TrackablesApiControllerImpl(TrackableService trackableService)
    {
      _trackableService = trackableService;
    }


    /// <summary>
    /// Create a Trackable.
    /// </summary>
    /// <remarks>Create a new Trackable from a json object containing all the required informations and add it to the world storage. &lt;br&gt;As a result you will get the ID of the newly created Trackable.</remarks>
    /// <param name="trackable">The Trackable to be added to the world storage.</param>
    /// <response code="200">OK, return the UUID of the Trackable defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="409">Invalid UUID, id must be a Nil value.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPost]
    [Route("/trackables")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("AddTrackable")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the Trackable defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 409, type: typeof(string), description: "Invalid UUID, id must be a Nil value.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult AddTrackable([FromBody] Trackable trackable)
    {
      if (String.IsNullOrEmpty(trackable.UUID.ToString()))
      {
        trackable.UUID = Guid.NewGuid();
      }
      try
      {
        Trackable mytrackable = _trackableService.Create(trackable);
        return StatusCode(200, mytrackable.UUID.ToString());
      }
      catch (Exception e)
      {
        return StatusCode(400, e.Message);
      }
    }

    /// <summary>
    /// Delete a Trackable.
    /// </summary>
    /// <remarks>Delete a single Trackable stored in the world storage from its ID.</remarks>
    /// <param name="trackableUUID">Trackable UUID to delete.</param>
    /// <response code="200">OK, delete successful.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpDelete]
    [Route("/trackables/{trackableUUID}")]
    [ValidateModelState]
    [SwaggerOperation("DeleteTrackable")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, delete successful.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult DeleteTrackable([FromRoute(Name = "trackableUUID")][Required] Guid trackableUUID)
    {
      DeleteResult answer = _trackableService.Remove(trackableUUID);
      // check, if used in WorldLink
      string result = "ok";
      string worldlinkinfo = "";
      List<WorldLink> worldlinklistfrom = _trackableService.GetWorldLinkUUIDFrom(trackableUUID);
      foreach (WorldLink worldlink in worldlinklistfrom)
      {
        worldlinkinfo += worldlink.UUID.ToString() + "; ";
        worldlink.UUIDFrom = Guid.Empty;
        worldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
        _trackableService.UpdateWorldLink(worldlink.UUID, worldlink);
      }
      List<WorldLink> worldlinklistto = _trackableService.GetWorldLinkUUIDTo(trackableUUID);
      foreach (WorldLink worldlink in worldlinklistto)
      {
        worldlinkinfo += worldlink.UUID.ToString() + "; ";
        worldlink.UUIDTo = Guid.Empty;
        worldlink.TypeTo = ObjectType.NotIdentifiedEnum;
        _trackableService.UpdateWorldLink(worldlink.UUID, worldlink);
      }
      if (worldlinkinfo.Length > 1)
      {
        result += ", removed object was referenced in " + worldlinkinfo + " and removed there as well";
      }
      return (answer.IsAcknowledged && answer.DeletedCount > 0) ? new ObjectResult(result) : StatusCode(404, "Not found, could not find UUID in database.");
    }

    /// <summary>
    /// Find a Trackable by its UUID.
    /// </summary>
    /// <remarks>Get a single Trackable stored in the world storage from its ID.</remarks>
    /// <param name="trackableUUID">UUID of the Trackable to retrieve.</param>
    /// <response code="200">Successful operation.</response>
    /// <response code="400">Invalid UUID supplied.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    [HttpGet]
    [Route("/trackables/{trackableUUID}")]
    [ValidateModelState]
    [SwaggerOperation("GetTrackableById")]
    [SwaggerResponse(statusCode: 200, type: typeof(Trackable), description: "Successful operation.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Invalid UUID supplied.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    public override IActionResult GetTrackableById([FromRoute(Name = "trackableUUID")][Required] Guid trackableUUID)
    {
      Trackable trackable = _trackableService.Get(trackableUUID);
      return (null != trackable) ? new ObjectResult(trackable) : StatusCode(404, "Not found, could not find UUID in database.");
    }

    /// <summary>
    /// Return all the Trackables.
    /// </summary>
    /// <remarks>Get all the Trackables currently being stored in the world storage.</remarks>
    /// <response code="200">OK, return all the Trackables defined by the world storage.</response>
    /// <response code="201">Null response.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpGet]
    [Route("/trackables")]
    [ValidateModelState]
    [SwaggerOperation("GetTrackables")]
    [SwaggerResponse(statusCode: 200, type: typeof(List<Trackable>), description: "OK, return all the Trackables defined by the world storage.")]
    [SwaggerResponse(statusCode: 201, type: typeof(string), description: "Null response.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult GetTrackables()
    {
      List<Trackable> trackablelist = _trackableService.Get();
      return new ObjectResult(trackablelist);
    }



    /// <summary>
    /// Modify a Trackable.
    /// </summary>
    /// <remarks>Modify an existing Trackable given a json object containing all the required informations. &lt;br&gt; **Please note that ID of the object is required in the JSON**</remarks>
    /// <param name="trackable">The Trackable to be modified in the world storage.</param>
    /// <response code="200">OK, return the UUID of the modified Trackable.</response>
    /// <response code="400">Bad request.</response>
    /// <response code="404">Not found, could not find UUID in database.</response>
    /// <response code="0">Unexpected error.</response>
    [HttpPut]
    [Route("/trackables")]
    [Consumes("application/json")]
    [ValidateModelState]
    [SwaggerOperation("ModifyTrackable")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, return the UUID of the modified Trackable.")]
    [SwaggerResponse(statusCode: 400, type: typeof(string), description: "Bad request.")]
    [SwaggerResponse(statusCode: 404, type: typeof(string), description: "Not found, could not find UUID in database.")]
    [SwaggerResponse(statusCode: 0, type: typeof(Error), description: "Unexpected error.")]
    public override IActionResult ModifyTrackable([FromBody] Trackable trackable)
    {
      ReplaceOneResult result = _trackableService.Update(trackable.UUID, trackable);
      if (result.MatchedCount == 0)
      {
        return StatusCode(404, "Not found, could not find UUID in database.");
      }
      else
      {
        return StatusCode(200, trackable.UUID.ToString());
      }
    }
  }
}
