//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using Org.OpenAPITools.Attributes;
using Org.OpenAPITools.Models;
using Microsoft.OpenApi.Models;

namespace Org.OpenAPITools.Controllers
{
  /// <summary>
  /// 
  /// </summary>
  [ApiController]
  public class DefaultApiControllerImpl : DefaultApiController
  {

    /// <summary>
        /// Get the state of the server.
    /// </summary>
    /// <response code="200">OK, world storage server ready.</response>
    [HttpGet]
    [Route("/admin")]
    [ValidateModelState]
    [SwaggerOperation("GetAdmin")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "OK, world storage server ready.")]
    public override IActionResult GetAdmin()
    {
      string version = "OK world storage server ready";
      return new ObjectResult(version);
      //return StatusCode(200, new ObjectResult(version));
    }

    /// <summary>
        /// Test the server availability.
    /// </summary>
        /// <response code="200">Ok, returns a string message.</response>
    [HttpGet]
    [Route("/ping")]
    [ValidateModelState]
    [SwaggerOperation("GetPing")]
        [SwaggerResponse(statusCode: 200, type: typeof(string), description: "Ok, returns a string message.")]
    public override IActionResult GetPing()
    {
      string answer = "OK, world storage alive.";
      return new ObjectResult(answer);
      //      return StatusCode(200, new ObjectResult(answer));
    }

    /// <summary>
    /// Get the version of the ARF API.
    /// </summary>
    /// <response code="200">Current version.</response>
    [HttpGet]
    [Route("/version")]
    [ValidateModelState]
    [SwaggerOperation("GetVersion")]
    [SwaggerResponse(statusCode: 200, type: typeof(string), description: "Current version.")]
    public override IActionResult GetVersion()
    {
      string version = "1.0.0";
      return new ObjectResult(version);
      //return StatusCode(200, new ObjectResult(version));
    }

  }
}
