*This repository is part of the outcomes of the Specialist Task Force 620 focusing on the authoring of a World Representation as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation authoring components includes:*

*•	The C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# Description - Version for STF 669

This repo should be used to construct a complete ASP-Net REST server compliant to the ARF World Storage API. It uses auto-generated ASP.NET server code. We propose to use the open source OpenAPI-Generator for this.

It includes description and code for a fully functional server with MongoDB integration.

## Repo Content

|   |  File / Folder |                                                                                    Description                                                                                    |
|:-:|:--------------:|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 📂 | server  | The folder where the library code will be generated, the openapi generator is set to not overwrite some files used to generate and initialiue the ASP.Net server system |
| 📂 | server/programs/MongoDB | This folder contains the MongoDB service. The World Storage database should be created or imported in a folder of your choice which path has to be editied in the .bat file |
| 📂 | server/src/Org.OpenAPITools | This is the location where the ASP.Net code will be generated |
| 📂 | server/src/Org.OpenAPITools/ControllersImpl | THis folder contains the code implementating the REST end-paths for the different objects in API |
| 📂 | server/src/Org.OpenAPITools/Services | This folder contains MongoDB database settings and access methods for each API |
| 📂 | arf005         | A submodule pointing to the git containing the API specification file                                                                                                |

## Requirements

What you need:

1.	Installed npm: https://phoenixnap.com/kb/install-node-js-npm-on-windows
2.	Installed openapi generator with npm: https://openapi-generator.tech/docs/installation/
3.	Installed docker (recommanded): https://www.docker.com/get-started 

# Code Generation

We provided the file `.openapi-generator-ignore` in `server`, which prevents openapi-generator to override some adapted files.

## Auto-generate server code
Open a command shell and execute:
```
  npx openapi-generator-cli generate -i openapi/API/worldstorage/worldstorageopenapi.yaml --additional-properties aspnetCoreVersion=5.0,packageName=ETSI.ARF.OpenAPI.WorldStorage,operationModifier=abstract,classModifier=abstract -g aspnetcore -o server/worldstorage
```

Open the solution `ETSI.ARF.OpenAPI.WorldStorage.sln` (folder `server/worldstorage`) in Visual Studio:

## In Visual Studio
Open `NuGet Package Manager` and add `MongoDB.Driver`.

### File adaptations
Change version number in all files if a new version is provided.

### Implementation folder (new)
All custom files are now in the folder 'ETSI-ARF'. Nothing to do adapt manually after generation. But you have to provide the implementation of new endpoints because they are now directly declared as abstract (default).

The folder contains following subfolders:
`Controllers`

Compare files folder in "`ETSI-ARF/Controllers`" with the corresponding files in "`Controllers`" and insert if necessary the new methods.

Methods should be the same with "`override`" instead of "`abstract`".

--- 

#### If some files are missing (and only then!)
Add 
```
  using MongoDB.Driver;
```

Add a private readonly service class variable like in the already existing files, e.g.:
```
private readonly TrackableService _trackableService;
```

Add a constructor with this service class variable like in the already existing files.
```
public TrackablesApiControllerImpl(TrackableService trackableService)
{
    _trackableService = trackableService;
}
```

Implement endpoint code using the appropriate MogoDB methods of the corresponding classes from the folder `Services` (which you may be have to create).

### In the folder `Models`
Add to the classes to be stored in the database (i.e. `Trackable.cs`, `WorldAnchor.cs`, `WorldLink.cs`) inherited from `IModels` (definition of the extra UUID): 
```
  using MongoDB.Bson;
  using MongoDB.Bson.Serialization.Attributes;
```

and at the value that is to become the MongoDB ID, add:
```
  [BsonId]
  [BsonRepresentation(BsonType.String)]
```

### Folder `Services`
The folder `Services` should contain one common class with the DatabaseSettings (`DatabaseSettings.cs`) and one with the database-access-methods (create, get, update, remove) for each API. If some are missing create them like the ones you find there. Be aware to add the reference to these in the file `startup.cs` in this case.

The naming in the DatabaseSettings is the same as defined in `appsettings.json`, which you have to extend when creating new classes in this folder. Change `appsettings.json` in the folder `docker` accordingly. Make sure that the ConnectionString for the database contains the correct IP address as specified in `docker-compose.yml`.

### In the folder `wwwroot`
Add in `openapi-original.json` in section `servers` the urls of the servers you want to use with swagger-ui

# MongoDB
If you don't have a MongoDB, follow the instructions in `readme.md` in `server/programs/MongoDB` 

...and put MongoDB in folder `server/programs/MongoDB` (download MongoDB as zip-file from https://www.mongodb.com/try/download/community and unzip the file into this directory, so that the bin-directory is in this folder).

## How to dump database 
Execute the following command in docker:
``` 
  mongodump --db **insert database_name** --out /data-dump/`date +"%Y-%m-%d"`
```

## How to import database
Execute the following command in docker:
```
  mongorestore --db **insert database_name** **insert path_to_bson_file**
```

# Use in Visual Studio
Make sure, that an instance of MongoDB is running.

Start application with IIS Express.


# Use API within a Docker

## Creating the IIS docker ##
Remove the substring `src/Org.OpenAPITools/` in Dockerfile (if not already done)

open a command shell and generate docker by executing:
```
  build-iis-docker-ws.bat
```

## How to start (with Docker-Compose)
The easiest way is to use docker-compose:

Open a command shell and use docker-compose (if necessary adapt docker-compose.yml) by executing`:
```
  docker-compose.bat
```

Open http://localhost:8080/openapi/index.html in a web-browser, if you want to check the functionalities using SwaggerUI

## How to stop
Open a command shell by executing in `server/worldstorage/src/ETSI.ARF.OpenAPI.WorldStorage`:
```
  docker-compose down
```
