using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Converters;
using MongoDB.Bson;
using MongoDB.Bson.Serialization.Attributes;

namespace ETSI.ARF.OpenAPI.WorldStorage.Models
{
    /// <summary>
    /// Base element representing an object in the MongoDB.
    /// </summary>
    public interface IModels
    {
        /// <summary>
        /// Accessor for the ID managed by mongo
        /// </summary>
        public ObjectId _mongoID { get; set; }

        // Not used!!!
        // public Metadata Metadata { get; set; }

        /// <summary>
        /// Name of the object
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// UUID is managed by ARF
        /// </summary>
        public Guid UUID { get; set; }
    }
}