using Microsoft.AspNetCore.Mvc.ModelBinding;
using Microsoft.AspNetCore.Mvc.ModelBinding.Binders;
using System;
using System.Threading.Tasks;
using Newtonsoft.Json;

using ETSI.ARF.OpenAPI.WorldStorage.Models;

namespace ETSI.ARF.OpenAPI.WorldStorage.Binders
{
    public class FromJsonBinderT<T> : IModelBinder
    {
        public Task BindModelAsync(ModelBindingContext bindingContext)
        {
            if (bindingContext == null)
            {
                throw new ArgumentNullException(nameof(bindingContext));
            }

            var modelName = bindingContext.ModelName;
            var jsonString = bindingContext.ActionContext.HttpContext.Request.Query[modelName];
            var valueProviderResult = bindingContext.ValueProvider.GetValue(modelName);

            if (valueProviderResult == ValueProviderResult.None)
            {
                return Task.CompletedTask;
            }

            bindingContext.ModelState.SetModelValue(modelName, valueProviderResult);

            var value = valueProviderResult.FirstValue;

            if (string.IsNullOrEmpty(value))
            {
                return Task.CompletedTask;
            }

            Console.WriteLine($"json string: {value}");

            T result = JsonConvert.DeserializeObject<T>(value);

            Console.WriteLine($"instance: {result}");
            
            bindingContext.Result = ModelBindingResult.Success(result);
            return Task.CompletedTask;
        }
    }
}