using Microsoft.AspNetCore.Mvc.ModelBinding;
using Microsoft.AspNetCore.Mvc.ModelBinding.Binders;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using System;

namespace ETSI.ARF.OpenAPI.WorldStorage.Binders
{
    public class FromJsonBinderProviderT<T> : IModelBinderProvider
    {
        public IModelBinder GetBinder(ModelBinderProviderContext context)
        {
            if (context == null)
            {
                throw new ArgumentNullException(nameof(context));
            }

            if (context.Metadata.ModelType == typeof(T))
            {
                return new BinderTypeModelBinder(typeof(FromJsonBinderT<T>));
            }

            return null;
        }
    }
}