//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2022 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2022
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Attributes;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using ETSI.ARF.OpenAPI.WorldStorage.Services;
using MongoDB.Driver;

namespace ETSI.ARF.OpenAPI.WorldStorage.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class WorldAnchorsApiControllerImpl : WorldAnchorsApiController
    {
        private readonly WorldAnchorService _worldAnchorService;

        /// <summary>
        /// 
        /// </summary>
        public WorldAnchorsApiControllerImpl(WorldAnchorService worldAnchorService)
        {
            _worldAnchorService = worldAnchorService;
        }


        /// <summary>
        /// Create a World Anchor.
        /// </summary>
        public override IActionResult AddWorldAnchor([FromBody] WorldAnchor worldAnchor, [FromHeader] string token)
        {
            if (String.IsNullOrEmpty(worldAnchor.UUID.ToString()))
            {
                worldAnchor.UUID = Guid.NewGuid();
            }
            try
            {
                WorldAnchor myworldanchor = _worldAnchorService.Create(worldAnchor);
                return StatusCode(200, myworldanchor.UUID.ToString());
            }
            catch (Exception e)
            {
                return StatusCode(400, e.Message);
            }
        }

        /// <summary>
        /// Delete a World Anchor.
        /// </summary>
        public override IActionResult DeleteWorldAnchor([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID, [FromHeader] string token)
        {
            // Access other service(s)
            WorldLinkService _worldLinkService = WorldLinkService.Singleton as WorldLinkService;

            long count = _worldAnchorService.Remove(worldAnchorUUID);
            // check, if used in WorldLink
            string result = "ok";
            string worldlinkinfo = "";

            // Update world links
            List<WorldLink> worldlinklistfrom = _worldLinkService.GetWorldLinkUUIDFrom(worldAnchorUUID);
            foreach (WorldLink worldlink in worldlinklistfrom)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDFrom = Guid.Empty;
                worldlink.TypeFrom = ObjectType.NotIdentifiedEnum;
                _worldLinkService.Replace(worldlink);
            }

            // Update world links
            List<WorldLink> worldlinklistto = _worldLinkService.GetWorldLinkUUIDTo(worldAnchorUUID);
            foreach (WorldLink worldlink in worldlinklistto)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDTo = Guid.Empty;
                worldlink.TypeTo = ObjectType.NotIdentifiedEnum;
                _worldLinkService.Replace(worldlink);
            }
            if (worldlinkinfo.Length > 1)
            {
                result += ", but removed object was referenced in " + worldlinkinfo + " and removed there as well";
            }
            return (count > 0) ? new ObjectResult(result) : StatusCode(404, "Not found, could not find UUID in database.");
        }

        /// <summary>
        /// Find a World Anchor by its UUID.
        /// </summary>
        public override IActionResult GetWorldAnchorById([FromRoute(Name = "worldAnchorUUID")][Required] Guid worldAnchorUUID, [FromHeader] string token)
        {
            WorldAnchor myworldanchor = _worldAnchorService.Get(worldAnchorUUID);
            return (null != myworldanchor) ? new ObjectResult(myworldanchor) : StatusCode(404, "Not found, could not find UUID in database.");
        }

        /// <summary>
        /// Return all the World Anchors.
        /// </summary>
        public override IActionResult GetWorldAnchors([FromHeader] string token)
        {
            List<WorldAnchor> worldanchorlist = _worldAnchorService.Get();
            return new ObjectResult(worldanchorlist);
        }



        /// <summary>
        /// Modify a World Anchor.
        /// </summary>
        public override IActionResult ModifyWorldAnchor([FromBody] WorldAnchor worldAnchor, [FromHeader] string token)
        {
            long count = _worldAnchorService.Replace(worldAnchor);
            if (count == 0)
            {
                return StatusCode(404, "Not found, could not find UUID in database.");
            }
            else
            {
                return StatusCode(200, worldAnchor.UUID.ToString());
            }
        }


    }
}
