//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

/*
 * World Storage API
 *
 * API ensuring interoperability between an authoring tool and a World Storage service
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldStorage.Attributes;
using ETSI.ARF.OpenAPI.WorldStorage.Models;
using ETSI.ARF.OpenAPI.WorldStorage.Services;
using MongoDB.Driver;

namespace ETSI.ARF.OpenAPI.WorldStorage.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class TrackablesApiControllerImpl : TrackablesApiController
    {
        private readonly TrackableService _trackableService;

        /// <summary>
        /// 
        /// </summary>
        public TrackablesApiControllerImpl(TrackableService trackableService)
        {
            _trackableService = trackableService;
        }


        /// <summary>
        /// Create a Trackable.
        /// </summary>
        public override IActionResult AddTrackable([FromBody] Trackable trackable, [FromHeader] string token)
        {
            if (String.IsNullOrEmpty(trackable.UUID.ToString()))
            {
                trackable.UUID = Guid.NewGuid();
            }
            try
            {
                Trackable mytrackable = _trackableService.Create(trackable);
                if (mytrackable == null)
                {
                    return StatusCode(409, new Error() { Message = "UUID already existing!" });
                }
                else return StatusCode(200, new Error() { Message = mytrackable.UUID.ToString() });
            }
            catch (Exception e)
            {
                return StatusCode(400, new Error() { Message = e.Message });
            }
        }

        /// <summary>
        /// Delete a Trackable.
        /// </summary>
        public override IActionResult DeleteTrackable([FromRoute(Name = "trackableUUID")][Required] Guid trackableUUID, [FromHeader] string token)
        {
            // Access other service(s)
            WorldLinkService _worldLinkService = WorldLinkService.Singleton as WorldLinkService;

            long count = _trackableService.Remove(trackableUUID);
            // check, if used in WorldLink
            string result = "ok";
            string worldlinkinfo = "";

            // Update world links
            List<WorldLink> worldlinklistfrom = _worldLinkService.GetWorldLinkUUIDFrom(trackableUUID);
            foreach (WorldLink worldlink in worldlinklistfrom)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDFrom = Guid.Empty;
                worldlink.TypeFrom = TypeWorldStorage.UNKNOWNEnum;
                _worldLinkService.Replace(worldlink);
            }

            // Update world links
            List<WorldLink> worldlinklistto = _worldLinkService.GetWorldLinkUUIDTo(trackableUUID);
            foreach (WorldLink worldlink in worldlinklistto)
            {
                worldlinkinfo += worldlink.UUID.ToString() + "; ";
                worldlink.UUIDTo = Guid.Empty;
                worldlink.TypeTo = TypeWorldStorage.UNKNOWNEnum;
                _worldLinkService.Replace(worldlink);
            }
            if (worldlinkinfo.Length > 1)
            {
                result += ", removed object was referenced in " + worldlinkinfo + " and removed there as well";
            }
            return (count > 0) ? new ObjectResult(result) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }

        /// <summary>
        /// Find a Trackable by its UUID.
        /// </summary>
        public override IActionResult GetTrackableById([FromRoute(Name = "trackableUUID")][Required] Guid trackableUUID, [FromHeader] string token)
        {
            Trackable trackable = _trackableService.Get(trackableUUID);
            return (null != trackable) ? new ObjectResult(trackable) : StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
        }

        /// <summary>
        /// Return all the Trackables.
        /// </summary>
        public override IActionResult GetTrackables([FromHeader] string token)
        {
            List<Trackable> trackablelist = _trackableService.Get();
            return new ObjectResult(trackablelist);
        }



        /// <summary>
        /// Modify a Trackable.
        /// </summary>
        public override IActionResult ModifyTrackable([FromBody] Trackable trackable, [FromHeader] string token)
        {
            long count = _trackableService.Replace(trackable);
            if (count == 0)
            {
                return StatusCode(404, new Error() { Message = "Not found, could not find UUID in database." });
            }
            else
            {
                return StatusCode(200, new Error() { Message = trackable.UUID.ToString() });
            }
        }
    }
}
