//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.REST
{
    public class WorldLinkRequest : RequestBase<WorldLink>
    {
        //
        // Wrapper for the endpoints
        //
        static public ResponseObject<WorldLink> GetWorldLinkAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<WorldLink>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Request 1 WorldLink...");
            ResponseObject<WorldLink> ro = new ResponseObject<WorldLink>("Request WorldLink " + UUID.ToString(), func);
            apiClient.GetWorldLinkByIdAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<WorldLink>, ro);
            return ro;
        }

        static public ResponseObject<List<WorldLink>> GetWorldLinksAsync(WorldStorageServer ws, Action<ResponseObject<List<WorldLink>>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Request WorldLinks...");
            ResponseObject<List<WorldLink>> ro = new ResponseObject<List<WorldLink>>("Request WorldLinks", func);
            apiClient.GetWorldLinksAsync(token, ro.cancellationToken).ContinueWith(OnReceiveListOfObjects<WorldLink>, ro);
            return ro;
        }

        static public ResponseObject<string> CreateWorldLinkAsync(WorldStorageServer ws, WorldLink worldLink, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Create 1 WorldLink...");

            // Add some management stuffs
            worldLink.UUID = Guid.NewGuid();
            worldLink.CreatorUUID = Guid.Empty;

            ResponseObject<string> ro = new ResponseObject<string>("Create WorldLink (no UUID)", func);
            apiClient.AddWorldLinkAsync(token, worldLink, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public ResponseObject<string> UpdateWorldLinkAsync(WorldStorageServer ws, WorldLink worldLink, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Update WorldLink...");
            ResponseObject<string> ro = new ResponseObject<string>("Update WorldLink " + worldLink.UUID.ToString(), func);
            apiClient.ModifyWorldLinkAsync(token, worldLink, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
        static public ResponseObject<string> DeleteWorldLinkAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Delete 1 WorldLink...");
            ResponseObject<string> ro = new ResponseObject<string>("Delete WorldLink " + UUID.ToString(), func);
            apiClient.DeleteWorldLinkAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
    }
}
//#endif