using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    public interface IModel
    {
        public System.Guid UUID { get; set; }

        public string ToJson();
    }

    // Class to monitor the server
    public class Server : IModel
    {
        public System.Guid UUID { get; set; }
        public string Name { get; set; }

        public Server(string name)
        {
            UUID = Guid.Empty;
            Name = name;
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }

    //
    // Implement here some constructors
    //
    public partial class Trackable : IModel
    {
        public Trackable(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }

    public partial class WorldAnchor : IModel
    {
        public WorldAnchor(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }

    public partial class WorldLink : IModel
    {
        public WorldLink()
        {
            UUID = Guid.NewGuid();
        }

        public string ToJson() { return JsonUtility.ToJson(this); }
    }
}