//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: September 2024
//
using System;
using System.Collections.Generic;
using ETSI.ARF.OpenAPI.WorldStorage;
using ETSI.ARF.OpenAPI;
using Newtonsoft.Json;

namespace ETSI.ARF.WorldStorage.REST
{ 
    public class RelocalizationInformationRequest : RequestBase<RelocalizationInformations>
    {

        static public ResponseObject<RelocalizationInformations> GetRelocalizationInformationAsync(WorldStorageServer ws, List<Guid> uuids, List<Mode_WorldStorage> modes, List<Capability> capabilities,  Action<ResponseObject<RelocalizationInformations>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new MyWorldStorageClient(httpClient);

            ResponseObject<RelocalizationInformations> ro = new ResponseObject<RelocalizationInformations>("Request Reloc Information ", func);
           
            List<UuidAndMode> anonymous = new List<UuidAndMode>();
            for (int i = 0;  i< uuids.Count; i++)
            {
                // Check same size or give anonymous as parameter?
                UuidAndMode newOne = new UuidAndMode();
                newOne.Uuid = uuids[i];
                newOne.Mode = modes[i];
                anonymous.Add(newOne);
            }
            apiClient.GetRelocalizationInformationAsync(token, anonymous, capabilities, ro.cancellationToken).ContinueWith(OnReceiveObject<RelocalizationInformations>, ro);
            return ro;
        }

        static public RelocalizationInformations GetRelocalizationInformation(WorldStorageServer ws, List<Guid> uuids, List<Mode_WorldStorage> modes, List<Capability> capabilities)
        {
            return GetRelocalizationInformationSync(ws, uuids, modes, capabilities);
        }

        static public RelocalizationInformations GetRelocalizationInformationSync(WorldStorageServer ws, List<Guid> uuids, List<Mode_WorldStorage> modes, List<Capability> capabilities)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new MyWorldStorageClient(httpClient);


            List<UuidAndMode> anonymous = new List<UuidAndMode>();
            for (int i = 0; i < uuids.Count; i++)
            {
                // Check same size or give anonymous as parameter?
                UuidAndMode newOne = new UuidAndMode();
                newOne.Uuid = uuids[i];
                newOne.Mode = modes[i];
                anonymous.Add(newOne);
            }

            RelocalizationInformations ro = apiClient.GetRelocalizationInformation(token, anonymous, capabilities);
            return ro;
        }
    }
}

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    public partial class WorldStorageClient
    {
        public ETSI.ARF.OpenAPI.WorldStorage.IHttpClient GetHttpClient()
        {
            return _httpClient;
        }

        public string ConvertToString_(object value, System.Globalization.CultureInfo cultureInfo)
        {
            return ConvertToString(value, cultureInfo);
        }


        public void PrepareRequest_(ETSI.ARF.OpenAPI.WorldStorage.IHttpClient client, System.Net.Http.HttpRequestMessage request, string url)
        {
            PrepareRequest(client, request, url);
        }
        public void PrepareRequest_(ETSI.ARF.OpenAPI.WorldStorage.IHttpClient client, System.Net.Http.HttpRequestMessage request, System.Text.StringBuilder urlBuilder)
        {
            PrepareRequest(client, request, urlBuilder);
        }
        public void ProcessResponse_(ETSI.ARF.OpenAPI.WorldStorage.IHttpClient client, System.Net.Http.HttpResponseMessage response)
        {
            ProcessResponse(client, response);
        }
    }

    // Custom client to be able to properly serialize objects in the query string
    public partial class MyWorldStorageClient : WorldStorageClient
    {
        public MyWorldStorageClient(IHttpClient httpClient) : base(httpClient)
        {
        }

        /// <summary>
        /// Override Nswag generated function to access relocalization information : deal with parameters in the query
        /// </summary>
        /// <param name="token"></param>
        /// <param name="uuids"></param>
        /// <param name="capabilities"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="System.ArgumentNullException"></exception>
        /// <exception cref="ApiException"></exception>
        /// <exception cref="ApiException{string}"></exception>
        /// <exception cref="ApiException{Error}"></exception>
        public override async System.Threading.Tasks.Task<RelocalizationInformations> GetRelocalizationInformationAsync(string token, System.Collections.Generic.IEnumerable<UuidAndMode> uuids, System.Collections.Generic.IEnumerable<Capability> capabilities, System.Threading.CancellationToken cancellationToken)
        {
            if (uuids == null)
                throw new System.ArgumentNullException("uuids");

            if (capabilities == null)
                throw new System.ArgumentNullException("capabilities");

            var client_ = GetHttpClient();
            var disposeClient_ = false;
            try
            {
                using (var request_ = new System.Net.Http.HttpRequestMessage())
                {

                    if (token != null)
                        request_.Headers.TryAddWithoutValidation("token", ConvertToString_(token, System.Globalization.CultureInfo.InvariantCulture));
                    request_.Method = new System.Net.Http.HttpMethod("GET");
                    request_.Headers.Accept.Add(System.Net.Http.Headers.MediaTypeWithQualityHeaderValue.Parse("application/json"));

                    var urlBuilder_ = new System.Text.StringBuilder();

                    urlBuilder_.Append("relocalizationInformation");
                    urlBuilder_.Append('?');
                    foreach (var item_ in uuids) { urlBuilder_.Append(System.Uri.EscapeDataString("uuids")).Append('=').Append(System.Uri.EscapeDataString(JsonConvert.SerializeObject(item_))).Append('&'); }
                    foreach (var item_ in capabilities) { urlBuilder_.Append(System.Uri.EscapeDataString("capabilities")).Append('=').Append(System.Uri.EscapeDataString(JsonConvert.SerializeObject(item_))).Append('&'); }
                    urlBuilder_.Length--;

                    PrepareRequest_(client_, request_, urlBuilder_);

                    var url_ = urlBuilder_.ToString();
                    request_.RequestUri = new System.Uri(url_, System.UriKind.RelativeOrAbsolute);

                    PrepareRequest_(client_, request_, url_);

                    var response_ = await client_.SendAsync(request_, System.Net.Http.HttpCompletionOption.ResponseHeadersRead, cancellationToken).ConfigureAwait(false);
                    var disposeResponse_ = true;
                    try
                    {
                        var headers_ = new System.Collections.Generic.Dictionary<string, System.Collections.Generic.IEnumerable<string>>();
                        foreach (var item_ in response_.Headers)
                            headers_[item_.Key] = item_.Value;
                        if (response_.Content != null && response_.Content.Headers != null)
                        {
                            foreach (var item_ in response_.Content.Headers)
                                headers_[item_.Key] = item_.Value;
                        }

                        ProcessResponse_(client_, response_);

                        var status_ = (int)response_.StatusCode;
                        if (status_ == 200)
                        {
                            var objectResponse_ = await ReadObjectResponseAsync<RelocalizationInformations>(response_, headers_, cancellationToken).ConfigureAwait(false);
                            if (objectResponse_.Object == null)
                            {
                                throw new ApiException("Response was null which was not expected.", status_, objectResponse_.Text, headers_, null);
                            }
                            return objectResponse_.Object;
                        }
                        else
                        if (status_ == 400)
                        {
                            var responseData_ = response_.Content == null ? null : await response_.Content.ReadAsStringAsync().ConfigureAwait(false);
                            var result_ = (string)System.Convert.ChangeType(responseData_, typeof(string));
                            throw new ApiException<string>("Invalid UUID supplied.", status_, responseData_, headers_, result_, null);
                        }
                        else
                        if (status_ == 404)
                        {
                            var responseData_ = response_.Content == null ? null : await response_.Content.ReadAsStringAsync().ConfigureAwait(false);
                            var result_ = (string)System.Convert.ChangeType(responseData_, typeof(string));
                            throw new ApiException<string>("Not found, could not find UUID in database.", status_, responseData_, headers_, result_, null);
                        }
                        else
                        {
                            var objectResponse_ = await ReadObjectResponseAsync<Error>(response_, headers_, cancellationToken).ConfigureAwait(false);
                            if (objectResponse_.Object == null)
                            {
                                throw new ApiException("Response was null which was not expected.", status_, objectResponse_.Text, headers_, null);
                            }
                            throw new ApiException<Error>("Unexpected error.", status_, objectResponse_.Text, headers_, objectResponse_.Object, null);
                        }
                    }
                    finally
                    {
                        if (disposeResponse_)
                            response_.Dispose();
                    }
                }
            }
            finally
            {
                if (disposeClient_)
                    client_.Dispose();
            }
        }
    }
}