using System;
using System.Collections;
using System.Collections.Generic;
using ETSI.ARF.OpenAPI.WorldStorage;
using UnityEngine;
using System.IO;
using ETSI.ARF.OpenAPI;

namespace ETSI.ARF.WorldStorage
{
    public class WorldStorageCollections
    {
        // MongoDB collections
        // Contains list after response from REST server
        public Data<Trackable> trackables = new Data<Trackable>();
        public Data<WorldAnchor> worldAnchors = new Data<WorldAnchor>();
        public Data<WorldLink> worldLinks = new Data<WorldLink>();

        public WorldStorageCollections()
        {
            trackables.list = new Dictionary<Guid, Trackable>();
            worldAnchors.list = new Dictionary<Guid, WorldAnchor>();
            worldLinks.list = new Dictionary<Guid, WorldLink>();
        }
    }
}
