//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

#define isDEBUG

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;

using UnityEngine;
using UnityEditor;
using TMPro;

using ETSI.ARF.WorldStorage.REST;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.UI
{
    public abstract class BaseWindow<T> : EditorWindow
    {
        [HideInInspector] public WorldStorageServer worldStorageServer;
        [HideInInspector] public WorldStorageUser worldStorageUser;

        [SerializeField] public List<string> trackables = new List<string>();

        //
        // Keyvalues
        //
        [SerializeField] protected KeyvalueTagList keyValueTags = new KeyvalueTagList();
        protected List<(string, string)> keyValuesFixed = new List<(string, string)>(4)
        {
            ("", ""),("", ""),("", ""),("", "")
        };
        protected void OutputKeyValue(int n)
        {
            string i1 = keyValuesFixed[n].Item1;
            string i2 = keyValuesFixed[n].Item2;
            i1 = EditorGUILayout.TextField("Key " + n, i1);
            i2 = EditorGUILayout.TextField("Value " + n, i2);
            keyValuesFixed[n] = (i1, i2);
        }

        //
        // UI stuffs
        //
        protected bool groupEnabled;
        protected bool repaint = false;
        protected Vector2 scrollPos;
        protected Color ori;
        protected GUIStyle gsTest;
        protected string saveText = "Save";

        public void Update()
        {
            if (repaint)
            {
                Repaint();
                repaint = false;
            }
        }

        void OnGUI()
        {
            ori = GUI.backgroundColor; // remember ori color

            gsTest = new GUIStyle("window");
            //gsTest.normal.textColor = WorldStorageWindow.arfColors[0];
            gsTest.fontStyle = FontStyle.Bold;
            gsTest.alignment = TextAnchor.UpperLeft;
            gsTest.fontSize = 16;

            scrollPos = EditorGUILayout.BeginScrollView(scrollPos, GUILayout.ExpandWidth(true));
            WorldStorageWindow.DrawCopyright();

            DrawUIStuffs();

            EditorGUILayout.EndScrollView();

            if (GUILayout.Button("Close Window"))
            {
                Close();
            }
        }

        public abstract void DrawUIStuffs();

        public virtual void GetParams()
        {
        }

        public virtual void AddObject()
        {
        }

        public virtual T GenerateObject()
        {
            return default(T);
        }
    }
}