﻿//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

using System;
using System.Collections.Generic;
using UnityEditor.Experimental.GraphView;
using UnityEngine;
using UnityEngine.UIElements;

using ETSI.ARF.WorldStorage.Editor.Windows;
using ETSI.ARF.WorldStorage.UI;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.Editor.Graph
{
    public class ARFPort : Port
    {
        protected ARFPort(Orientation portOrientation, Direction portDirection, Capacity portCapacity, Type type) : base(portOrientation, portDirection, portCapacity, type)
        {
        }

        public override void Connect(Edge edge)
        {
            base.Connect(edge);
            ARFNode fromNode = edge.output.node as ARFNode;
            ARFNode toNode = edge.input.node as ARFNode;

            if (edge is ARFEdgeLink aRFedge)
            {
                Transform3D transform = new Transform3D();
                for (int i = 0; i < 15; i++)
                {
                    transform.Add(0);
                }
                transform.Add(1);

                WorldLink worldLink = new WorldLink()
                {
                    UUID = Guid.NewGuid(),
                    CreatorUUID = Guid.Parse(SaveInfo.instance.worldStorageUser.UUID),
                    UUIDFrom = Guid.Parse(fromNode.GUID),
                    UUIDTo = Guid.Parse(toNode.GUID),
                    TypeFrom = fromNode.GetElemType(),
                    TypeTo = toNode.GetElemType(),
                    Transform = transform,
                    Unit = UnitSystem.CM
                };
                aRFedge.worldLink = worldLink;
            }
        }

        public static ARFPort CreateARF<TEdge>(Orientation orientation, Direction direction, Capacity capacity, Type type) where TEdge : Edge, new()
        {
            WorldLinkListener listener = new WorldLinkListener();
            ARFPort port = new(orientation, direction, capacity, type)
            {
                m_EdgeConnector = new EdgeConnector<TEdge>(listener)
            };
            port.AddManipulator(port.m_EdgeConnector);
            return port;
        }
    }
}