// The Fraunhofer HHI Unity Framework
//  ___________                          .__            _____                ___ ___    ___ ___ .___ 
//  \_   _____/___________   __ __  ____ |  |__   _____/ ____\___________   /   |   \  /   |   \|   |
//   |    __) \_  __ \__  \ |  |  \/    \|  |  \ /  _ \   __\/ __ \_  __ \ /    ~    \/    ~    \   |
//   |     \   |  | \// __ \|  |  /   |  \   Y  (  <_> )  | \  ___/|  | \/ \    Y    /\    Y    /   |
//   \___  /   |__|  (____  /____/|___|  /___|  /\____/|__|  \___  >__|     \___|_  /  \___|_  /|___|
//       \/               \/           \/     \/                 \/               \/         \/      
// (C) Fraunhofer HHI, 2024

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using UnityEngine;

namespace ETSI.ARF.OpenAPI
{
    public class ResponseObject<T>
    {
        // Management stuffs
        static int ID = 0;
        public int transactionId = 0;
        public string message = "";     // custom message, type of data...
        
        // Time monitoring
        public TimeSpan DeltaTime { get => responseTime - requestTime; }
        public DateTime requestTime;
        public DateTime responseTime;

        // Incoming data
        public T result;
        public int payload;   // size of data
        
        //public string result = "";      // text result
        //public object data = null;      // custom result

        // Callback
        public Action<ResponseObject<T>> callback;

        // Task cancelllation
        public CancellationToken cancellationToken { get => ct; }
        private CancellationTokenSource tokenSource;
        private CancellationToken ct;


        public ResponseObject(string msg, Action<ResponseObject<T>> func = null)
        {
            requestTime = DateTime.Now;
            transactionId = ++ID;
            message = msg;
            
            callback = func;

            tokenSource = new CancellationTokenSource();
            ct = tokenSource.Token;
        }

        public void Cancel()
        {
            tokenSource.Cancel();
        }
    }
}