using ETSI.ARF.OpenAPI.WorldStorage;
using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class WorldStorageUnityHelper
{
    /// <summary>
    /// Convert a float array of length 16 to a Matrix
    /// </summary>
    /// <param name="matrix">the values to convert</param>
    /// <returns>Converted Unity Matrix</returns>
    public static ETSI.ARF.OpenAPI.WorldStorage.Transform3D ConvertUnityToETSIARFTransform3D(Matrix4x4 value)
    {
        Transform3D result = new Transform3D
            {
                value.m00,    value.m01,    value.m02,    value.m03,
                value.m10,    value.m11,    value.m12,    value.m13,
                value.m20,    value.m21,    value.m22,    value.m23,
                value.m30,    value.m31,    value.m32,    value.m33,
            };
        return result;
    }

    /// <summary>
    /// Convert a float array of length 16 to a Matrix
    /// </summary>
    /// <param name="matrix">the values to convert</param>
    /// <returns>Converted Unity Matrix</returns>
    public static Matrix4x4 ConvertETSIARFTransform3DToUnity(ETSI.ARF.OpenAPI.WorldStorage.Transform3D value)
    {
        if (value.Count == 16)
        {
            Matrix4x4 resul = new Matrix4x4();
            resul[0, 0] = value[0];
            resul[0, 1] = value[1];
            resul[0, 2] = value[2];
            resul[0, 3] = value[3];

            resul[1, 0] = value[4];
            resul[1, 1] = value[5];
            resul[1, 2] = value[6];
            resul[1, 3] = value[7];

            resul[2, 0] = value[8];
            resul[2, 1] = value[9];
            resul[2, 2] = value[10];
            resul[2, 3] = value[11];

            resul[3, 0] = value[12];
            resul[3, 1] = value[13];
            resul[3, 2] = value[14];
            resul[3, 3] = value[15];

            return resul;
        }
        else
        {
            throw new ArgumentException("The numer of floats in the value parameter must be 16!");
        }
    }

    static public Matrix4x4 MatrixFromLocalCRS(List<float> value)
    {
        Matrix4x4 result = new Matrix4x4();
        result.m00 = value[0]; result.m01 = value[1]; result.m02 = value[2]; result.m03 = value[3];
        result.m10 = value[4]; result.m11 = value[5]; result.m12 = value[6]; result.m13 = value[7];
        result.m20 = value[8]; result.m21 = value[9]; result.m22 = value[10]; result.m23 = value[11];
        result.m30 = value[12]; result.m31 = value[13]; result.m32 = value[14]; result.m33 = value[15];
        return result;
    }
}
