//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

//#if UNITY_EDITOR
namespace ETSI.ARF.WorldStorage.REST
{
    public class WorldAnchorRequest : RequestBase<WorldAnchor>
    {
        //
        // Wrapper for the endpoints
        //
        static public ResponseObject<WorldAnchor> GetWorldAnchorAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<WorldAnchor>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Request 1 WorldAnchor...");
            ResponseObject<WorldAnchor> ro = new ResponseObject<WorldAnchor>("Request WorldAnchor " + UUID.ToString(), func);
            apiClient.GetWorldAnchorByIdAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<WorldAnchor>, ro);
            return ro;
        }

        static public List<WorldAnchor> GetWorldAnchorsSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            return apiClient.GetWorldAnchors(token);
        }

        static public ResponseObject<List<WorldAnchor>> GetWorldAnchorsAsync(WorldStorageServer ws, Action<ResponseObject<List<WorldAnchor>>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Request WorldAnchors...");
            ResponseObject<List<WorldAnchor>> ro = new ResponseObject<List<WorldAnchor>>("Request WorldAnchors", func);
            apiClient.GetWorldAnchorsAsync(token, ro.cancellationToken).ContinueWith(OnReceiveListOfObjects<WorldAnchor>, ro);
            return ro;
        }

        static public ResponseObject<string> CreateWorldAnchorAsync(WorldStorageServer ws, WorldAnchor worldAnchor, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Create 1 WorldAnchor...");

            // Add some management stuffs
            if (worldAnchor.UUID == Guid.Empty) worldAnchor.UUID = Guid.NewGuid();
            if (worldAnchor.CreatorUUID == Guid.Empty) worldAnchor.CreatorUUID = System.Guid.Parse("8fb169e2-8910-4cd5-a8f9-b7abff38d013");

            ResponseObject<string> ro = new ResponseObject<string>("Create WorldAnchor " + worldAnchor.Name + " (no UUID)", func);
            apiClient.AddWorldAnchorAsync(token, worldAnchor, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public ResponseObject<string> UpdateWorldAnchorAsync(WorldStorageServer ws, WorldAnchor worldAnchor, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Update WorldAnchor...");
            ResponseObject<string> ro = new ResponseObject<string>("Update WorldAnchor " + worldAnchor.UUID.ToString(), func);
            apiClient.ModifyWorldAnchorAsync(token, worldAnchor, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
        static public ResponseObject<string> DeleteWorldAnchorAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("[REST] Delete 1 WorldAnchor...");
            ResponseObject<string> ro = new ResponseObject<string>("Delete WorldAnchor " + UUID.ToString(), func);
            apiClient.DeleteWorldAnchorAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
    }
}
//#endif