*This repository is part of the outcomes of the Specialist Task Force 620 focusing on the authoring of a World Representation as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation authoring components includes:*

*•	The C++ and C# source code for servers and clients generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# Preliminary

Up now, January 2024, the Unity version supoorted by the ARF is 2022 LTS. 

# Description

This is a Unity package to be included in Unity projects for accessing the ISG ARF World Storage (and/or WorldAnalysis) data. It contains the c# modules generated from the ISG ARF World Storage C# Client available at https://labs.etsi.org/rep/arf/world-storage-api-helpers/world-storage-csharp-client. 

This package also contains some examplary runtime scripts. They demonstrate how to use the API in combination with scriptable objects to set up various servers and users.

# How to checkout

This project should be directly added as package to a Unity project. This can either be done

- by checking it out into the `Packages` folder of the Unity project using the `git clone` command or
- by directly referencing the repository using the Package Manager integrated in Unity.

The second variant is recommended. It has been available since Unity 2020.

When cloning the package into the `Packages` folder of a Unity project which itself is a git project, then the package should be referenced as git submodule. How this is done is documented in the https://git-scm.com/book/en/v2/Git-Tools-Submodules. An example project provided by the ISG ARF using this approach is available at https://labs.etsi.org/rep/arf/world-storage-api-helpers/unity-world-storage-editor.

# Setting up Unity

Add the NewtonSoft package. Go in the package manager from Unity and add a package by name:

    Name: com.unity.nuget.newtonsoft-json
    version: 3.2.1

Change the Unity prefs to use the NET Framework (not only 2.1)

Add a file "csc.rsp":

    -r:System.ComponentModel.DataAnnotations.dll

# How to update the client DLLs

To update the client API module(s)

- checkout the ISG ARF World Storage C# Client available at https://labs.etsi.org/rep/arf/world-storage-api-helpers/world-storage-csharp-client,
- build the ISG ARF World Storage C# Client as indicated in the corresponding `README.md` file,
- copy the content of the folder client\csharp-nswag` of that project into the `Plugins` folder of this project,
- commit the changes of this project to the repository.

Please ensure always to use the newest version of the ISG ARF World Storage C# Client.
