//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

#define USING_OPENAPI_GENERATOR // alt. is Swagger

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;

using ETSI.ARF.OpenAPI.WorldStorage;
using ETSI.ARF.OpenAPI;

namespace ETSI.ARF.WorldStorage.REST
{
    public class TrackableRequest : RequestBase<Trackable>
    {
        //
        // Wrapper for the endpoints
        //
        static public ResponseObject<Trackable> GetTrackableAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<Trackable>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Request 1 Trackable...");
            ResponseObject<Trackable> ro = new ResponseObject<Trackable>("Request Trackable " + UUID.ToString(), func);
            apiClient.GetTrackableByIdAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<Trackable>, ro);
            return ro;
        }

        static public ResponseObject<List<Trackable>> GetTrackablesAsync(WorldStorageServer ws, Action<ResponseObject<List<Trackable>>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Request Trackables...");
            ResponseObject<List<Trackable>> ro = new ResponseObject<List<Trackable>>("Request Trackables", func);
            apiClient.GetTrackablesAsync(token, ro.cancellationToken).ContinueWith(OnReceiveListOfObjects<Trackable>, ro);
            return ro;
        }

        static public ResponseObject<string> CreateTrackableAsync(WorldStorageServer ws, Trackable trackable, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Create 1 Trackable...");

            // Add some management stuffs
            trackable.UUID = Guid.NewGuid();
            trackable.CreatorUUID = Guid.Empty;
            
            ResponseObject<string> ro = new ResponseObject<string>("Create Trackable " + trackable.Name + " (no UUID)", func);
            apiClient.AddTrackableAsync(token, trackable, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public ResponseObject<string> UpdateTrackableAsync(WorldStorageServer ws, Trackable trackable, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Update Trackable...");
            ResponseObject<string> ro = new ResponseObject<string>("Update Trackable " + trackable.UUID.ToString(), func);
            apiClient.ModifyTrackableAsync(token, trackable,ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
        static public ResponseObject<string> DeleteTrackableAsync(WorldStorageServer ws, Guid UUID, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Delete 1 Trackable...");
            ResponseObject<string> ro = new ResponseObject<string>("Delete Trackable " + UUID.ToString(), func);
            apiClient.DeleteTrackableAsync(token, UUID, ro.cancellationToken).ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
    }
}