//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Threading.Tasks;
using UnityEngine;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.REST
{
    public class AdminRequest : RequestBase<string>
    {
        //
        // Wrapper for the endpoints
        //
        static private string Ping(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            string response = apiClient.GetPing();
            return response;
        }

        static public ResponseObject<string> PingAsync(WorldStorageServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Request Ping...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Ping", func);
            apiClient.GetPingAsync().ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public ResponseObject<string> AdminAsync(WorldStorageServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Request Admin...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Admin", func);
            apiClient.GetAdminAsync().ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }

        static public ResponseObject<string> VersionAsync(WorldStorageServer ws, Action<ResponseObject<string>> func)
        {
            wsServer = ws;
            var httpClient = new UnityWebRequestHttpClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Debug.Log("Request Version...");
            ResponseObject<string> ro = new ResponseObject<string>("Request Version", func);
            apiClient.GetVersionAsync().ContinueWith(OnReceiveObject<string>, ro);
            return ro;
        }
    }
}
