//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Networking;

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    // SylR
    public partial class WorldStorageClient
    {
        public string lastJsonText;
        public long lastPayload;

        partial void PrepareRequest(IHttpClient client, System.Net.Http.HttpRequestMessage request, string url)
        {
            // If needed to make some special things !!!
        }

        partial void PrepareRequest(IHttpClient client, System.Net.Http.HttpRequestMessage request, System.Text.StringBuilder urlBuilder)
        {
            // do something...
        }

        partial void ProcessResponse(IHttpClient client, System.Net.Http.HttpResponseMessage response)
        {
            lastJsonText = response.Content.ReadAsStringAsync().Result.ToString();
            lastPayload = response.Content.Headers.ContentLength.Value;

            // If needed to make some special things !!!
        }
    }
}