using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    public interface IModel
    {
        public System.Guid UUID { get; set; }
    }

    //
    // Implement here some constructors
    //
    public partial class Trackable : IModel
    {
        public Trackable(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }
    }

    public partial class WorldAnchor : IModel
    {
        public WorldAnchor(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }
    }

    public partial class WorldLink : IModel
    {
        public WorldLink()
        {
            UUID = Guid.NewGuid();
        }
    }
}