#!/usr/bin/env python

#
# ARF - Augmented Reality Framework (ETSI ISG ARF)
#
# Copyright 2024 ETSI
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Last change: July 2024
#

import time
import asyncio
import pathlib
import websockets;
import ssl
from pprint import pprint

from websockets.server import serve


print()
print("ETSI ISG - Test WebSocket Server")
print()
print()

success = 0

# certificate
localhost_pem = pathlib.Path(__file__).with_name("localhost.pem")
print(f"Using PEM: {localhost_pem}")
print()

# See here: https://websockets.readthedocs.io/en/stable/howto/quickstart.html#encrypt-connections
my_ssl_context = ssl.SSLContext(ssl.PROTOCOL_TLS_CLIENT)
my_ssl_context.load_verify_locations(localhost_pem)


# https://websockets.readthedocs.io/en/stable/index.html
async def echo(websocket):
    async for message in websocket:
        print(f"Got: { message }")
        await websocket.send(message)

async def main():
    async with serve(echo, "localhost", 8765):
        await asyncio.Future()  # run forever

asyncio.run(main())