//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Collections.Generic;
using System.Threading.Tasks;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

//#if UNITY_EDITOR
namespace ETSI.ARF.WorldStorage.REST
{
    public class WorldAnchorRequest : RequestBase<WorldAnchor>
    {
        //
        // Wrapper for the endpoints
        //
        static public WorldAnchor GetWorldAnchorSync(WorldStorageServer ws, Guid UUID)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            //Console.WriteLine($"[REST] Request WorldAnchor {UUID}...");
            return apiClient.GetWorldAnchorById(token, UUID);
        }

        static public List<WorldAnchor> GetWorldAnchorsSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine("[REST] Request WorldAnchors...");
            return apiClient.GetWorldAnchors(token).WorldAnchors as List<WorldAnchor>;
        }

        static public string CreateWorldAnchorSync(WorldStorageServer ws, WorldAnchor worldAnchor)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            // Add some management stuffs
            if (worldAnchor.UUID == Guid.Empty) worldAnchor.UUID = Guid.NewGuid();
            if (worldAnchor.CreatorUUID == Guid.Empty) worldAnchor.CreatorUUID = System.Guid.Parse("8fb169e2-8910-4cd5-a8f9-b7abff38d013");

            //Console.WriteLine($"[REST] Create WorldAnchor {worldAnchor.UUID}...");
            return apiClient.AddWorldAnchor(token, worldAnchor).Message;
        }

        static public string UpdateWorldAnchorSync(WorldStorageServer ws, WorldAnchor worldAnchor)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine($"[REST] Update WorldAnchor {worldAnchor.UUID}...");
            return apiClient.ModifyWorldAnchor(token, worldAnchor).Message;
        }

        static public string DeleteWorldAnchorSync(WorldStorageServer ws, Guid UUID)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine($"[REST] Delete WorldAnchor {UUID}...");
            return apiClient.DeleteWorldAnchor(token, UUID).Message;
        }
    }
}
//#endif