//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

using System;
using System.Collections.Generic;
using System.Threading.Tasks;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.REST
{
    public class TrackableRequest : RequestBase<Trackable>
    {
        //
        // Wrapper for the endpoints
        //
        static public Trackable GetTrackableSync(WorldStorageServer ws, Guid UUID)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            //Console.WriteLine($"[REST] Request Trackable {UUID}...");
            return apiClient.GetTrackableById(token, UUID);
        }
        
        static public List<Trackable> GetTrackablesSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine("[REST] Request Trackables...");
            return apiClient.GetTrackables(token).Trackables as List<Trackable>;
        }

        static public string CreateTrackableSync(WorldStorageServer ws, Trackable trackable)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            // Add some management stuffs
            if (trackable.UUID == Guid.Empty) trackable.UUID = Guid.NewGuid();
            if (trackable.CreatorUUID == Guid.Empty) trackable.CreatorUUID = System.Guid.Parse("8fb169e2-8910-4cd5-a8f9-b7abff38d013");

            Console.WriteLine($"[REST] Create Trackable {trackable.UUID}...");
            return apiClient.AddTrackable(token, trackable).Message;
        }

        static public string UpdateTrackableSync(WorldStorageServer ws, Trackable trackable)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine($"[REST] Update Trackable {trackable.UUID}...");
            return apiClient.ModifyTrackable(token, trackable).Message;
        }

        static public string DeleteTrackableSync(WorldStorageServer ws, Guid UUID)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            Console.WriteLine($"[REST] Delete Trackable {UUID}...");
            return apiClient.DeleteTrackable(token, UUID).Message;
        }
    }
}