//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: March 2024
//

using System;
using System.Threading.Tasks;

using ETSI.ARF.OpenAPI;
using ETSI.ARF.OpenAPI.WorldStorage;

namespace ETSI.ARF.WorldStorage.REST
{
    public class AdminRequest : RequestBase<string>
    {
        //
        // Wrapper for the endpoints
        //
        static public string PingSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            string response = apiClient.GetPing();
            return response;
        }

        static public string AdminSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            string response = apiClient.GetAdmin();
            return response;
        }


        static public string VersionSync(WorldStorageServer ws)
        {
            wsServer = ws;
            var httpClient = new BasicHTTPClient(ws.URI);
            apiClient = new WorldStorageClient(httpClient);

            string response = apiClient.GetVersion();
            return response;
        }
    }
}
