﻿using System;
using System.Collections.Generic;

namespace WorldAnalysisWrapper
{
    class Program
    {
        // Use visual studio setups
        static public bool isDev = true;

        // Use secure protocols
        static bool isDev_Secure = true;
        
        // Use localhost
        static bool isLocalNetwork = true;

        static public WorldAnalysis module;

        //
        // Web server (World Storage)
        //
        static private string webserver_url;

        //
        // WebSocket server (World Analysis)
        //
        static private string websocket_url;

        static void Main(string[] args)
        {
            //
            // Web server
            //
            // for production
            webserver_url = "https://etsi.hhi.fraunhofer.de";  // public

            //
            // WebSockets
            //

            if (isDev)
            {
                // For development

                if (isDev_Secure) websocket_url = "wss://localhost:44301/ws";  // secure
                else websocket_url = "ws://localhost:61788/ws";
            }
            else
            {
                // For production

                if (isLocalNetwork) websocket_url = "ws://192.168.20.29:8084/ws"; // local network
                else websocket_url = "wss://analysis.etsi.hhi.fraunhofer.de";  // public
            }


            Console.WriteLine("Starting World Analysis module...");
            module = new WorldAnalysis(webserver_url, websocket_url, 2);
            module.Start();

            while (module.isRunning())
            {
                // don't exit here, wait!
            }
        }
    }
}
