//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: September 2024
//

// Depends on UniTask to support cancellation token and GetAwaiter: https://github.com/Cysharp/UniTask
// Otherwise, the code can be adapted using https://gist.github.com/krzys-h/9062552e33dd7bd7fe4a6c12db109a1a

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading;
using System.Threading.Tasks;
//using Cysharp.Threading.Tasks;

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    public interface IHttpClient
    {
        public Uri BaseAddress { get; set; }
        public HttpRequestHeaders DefaultRequestHeaders { get; }

        public Task<HttpResponseMessage> SendAsync(HttpRequestMessage message, HttpCompletionOption option,
            CancellationToken token);

        public void Dispose();
    }

    public class BasicHTTPClient : IHttpClient
    {

        public BasicHTTPClient() { }

        public BasicHTTPClient(string baseUri)
        {
            BaseAddress = new Uri(baseUri);
            _httpClient.BaseAddress = BaseAddress;
        }

        public BasicHTTPClient(Uri baseUri)
        {
            BaseAddress = baseUri;
            _httpClient.BaseAddress = BaseAddress;
        }

        public Uri BaseAddress { get; set; }
        public HttpRequestHeaders DefaultRequestHeaders => _httpClient.DefaultRequestHeaders;

        private readonly HttpClient _httpClient = new HttpClient();

        public async Task<HttpResponseMessage> SendAsync(HttpRequestMessage message, HttpCompletionOption option, CancellationToken token)
        {
            return await _httpClient.SendAsync(message, option, token);
        }

        public void Dispose()
        {
            _httpClient.Dispose();
            DefaultRequestHeaders.Clear();
            BaseAddress = null;
        }
    }
}