using System;
using System.Collections;
using System.Collections.Generic;
using System.Numerics;
using Newtonsoft.Json;

namespace ETSI.ARF.OpenAPI.WorldStorage
{
    public partial class Transform3D
    {
        public Matrix4x4 Matrix()
        {
            return new Matrix4x4(
                this[0], this[1], this[2], this[3],
                this[4], this[5], this[6], this[7],
                this[8], this[9], this[10], this[11],
                this[12], this[13], this[14], this[15]
            );
        }
    }

    public interface IModel
    {
        public System.Guid UUID { get; set; }

        public string ToJson();
    }

    // Class to monitor the server
    public class Server : IModel
    {
        public System.Guid UUID { get; set; }
        public string Name { get; set; }

        public Server(string name)
        {
            UUID = Guid.Empty;
            Name = name;
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }

    //
    // Implement here some constructors
    //
    public partial class Trackable : IModel
    {
        public Trackable(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }

    public partial class WorldAnchor : IModel
    {
        public WorldAnchor(string name)
        {
            UUID = Guid.NewGuid();
            Name = name;
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }

    public partial class WorldLink : IModel
    {
        public WorldLink()
        {
            UUID = Guid.NewGuid();
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }
}