using System;
using System.Collections;
using System.Collections.Generic;
using System.Numerics;
using Newtonsoft.Json;

namespace ETSI.ARF.OpenAPI.WorldAnalysis
{
    public interface IModel
    {
        public System.Guid Uuid { get; set; }  // Bug: SylR: Why is Uuid not capitalized (UUID)???

        public string ToJson();
    }

    // Class to monitor the server
    public class Server : IModel
    {
        public System.Guid Uuid { get; set; }
        public string Name { get; set; }

        public Server(string name)
        {
            Uuid = Guid.Empty;
            Name = name;
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }

    //
    // Implement here some constructors
    //
    public partial class Pose : IModel
    {
        public Pose()
        {
            Uuid = Guid.NewGuid();
        }

        public string ToJson() { return JsonConvert.SerializeObject(this); }
    }

    public partial class Transform3D
    {
        public Matrix4x4 Matrix()
        {
            return new Matrix4x4(
                this[0], this[1], this[2], this[3],
                this[4], this[5], this[6], this[7],
                this[8], this[9], this[10], this[11],
                this[12], this[13], this[14], this[15]
            );
        }
    }
}