*This repository is part of the outcomes of the Specialist Task Force 669 focusing on the communication between a World Analysis and World Representation components as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Representation authoring components includes:*

*•	The Python, C++ and C# source code for servers and clients generated from OpenAPI available here (https://forge.etsi.org/rep/arf/arf005)*

*•	A Unity plugin and a Unity editor for authoring and accessing a World Representation hosted on a World Storage server.*

*All these components are available under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

# Description

This repo should be used to construct a Python server compliant to the ARF World Storage API. It uses auto-generated python server code. We propose to use the open source OpenAPI-Generator for this.


## Repo Content

|   |  Files / Folders |                                                                                    Description                                                                                    |
|:-:|:--------------:|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 📂 | wrapper  | The folder where the python World Analysis code with WS REST and WA websocket connection is implemented |

## Requirements

What you need:

1.	Installed npm: https://phoenixnap.com/kb/install-node-js-npm-on-windows
2.	Installed openapi generator with npm: https://openapi-generator.tech/docs/installation/
3.	Optional: Installed docker (recommanded): https://www.docker.com/get-started 

## Auto-generate client code for WS

Use/define following setup for the config file `openapitools.json`:

```
{
  "$schema": "node_modules/@openapitools/openapi-generator-cli/config.schema.json",
  "spaces": 2,
  "generator-cli": {
    "version": "7.6.0",
    "generators":{
      "python": {
     "generatorName": "python",
     "output": "./generated_wa_client",
     "inputSpec": "./openapi/API/worldanalysis/worldanalysisopenapi.yaml",
     "additionalProperties": {
      "packageName": "ETSI.ARF.OpenAPI.WorldAnalysis"
     }
     }
    }
  }
}
```

Open a command shell and execute:
```
  npx openapi-generator-cli generate
```

## Installing the python module on your local computer

It's recommended to create the enviroment with conda (if available)

```
conda create -n openapi
conda activate openapi
```

Install the World Analysis OpenAPI:

```
pip install .\generated_wa_client
```

In case of not having the pip installed for your cml you can use following line:

```
py -m pip install .\generated_wa_client
```

## Installing the python module for WebSockets on your local computer

Install the common package for async WebSockets:

```
pip install websockets
```

In case of not having the pip installed for your cml you can use following line:

```
py -m pip install websockets
```

## Running the test script

Run python script with:
```
cd wrapper
python WorldAnalysisWrapper.py
```