//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

/*
 * World Analysis API
 *
 * API ensuring interoperability between Scene Management and a World Analysis service
 *
 * The version of the OpenAPI document: 2.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldAnalysis.Attributes;
using ETSI.ARF.OpenAPI.WorldAnalysis.Models;

namespace ETSI.ARF.OpenAPI.WorldAnalysis.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class PoseApiControlleImpl : PoseApiController
    {
        /// <summary>
        /// Specify the a minimum frame rate for pose estimation for Trackable types
        /// </summary>
        public override IActionResult ConfigureFramerate([FromBody] PoseConfiguration poseConfiguration, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // Notify the modules that the client need a new framerate
            bool result = WorldAnalysisConnections.Singleton.ConfigureFramerate(poseConfiguration);
            return result ? StatusCode(200, new Success() { Message = "Ok." }) : StatusCode(405, new Error() { Message = "Not supported." });
        }

        /// <summary>
        /// Request the last pose of a single Anchor or Trackable
        /// </summary>
        public override IActionResult GetPose([FromRoute(Name = "trackableOrAnchorUUID")][Required] Guid trackableOrAnchorUUID, [FromQuery(Name = "mode")][Required()] ModeWorldAnalysis mode, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // Request from the modules a new pose of a single UUID
            Pose result;
            result = WorldAnalysisConnections.Singleton.GetPose(trackableOrAnchorUUID, mode);
            return new ObjectResult(result);
        }

        /// <summary>
        /// Request the last pose of a batch of Anchor or Trackable
        /// </summary>
        public override IActionResult GetPoses([FromQuery(Name = "uuid")][Required()] List<UuidAndMode> uuid, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // Request from the modules new poses from all UUIDs
            GetPoses200Response result = new GetPoses200Response();
            foreach (var item in uuid)
            {
                result.Poses.Add(WorldAnalysisConnections.Singleton.GetPose(item.Uuid, item.Mode));
            }
            return new ObjectResult(result);
        }

#pragma warning disable CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element

        //
        // Management of subscriptions
        //
        /// <summary>
        /// Dictionnary of susbscription informations for poses, for each item, stored using the UUID of the item (anchor/trackable)
        /// </summary>
        private Dictionary<Guid, SubscriptionInfo> m_subscriptionsPoses = new Dictionary<Guid, SubscriptionInfo>();

        public struct SubscriptionInfo
        {
            public Guid uuidSub;           // id of subscription (id is defined by the WA server)

            public SubscribeToPoseRequest subscription;
            public string webSocket;
            public Pose pose;
            public DateTime timeValidity;

            //public PoseCallback callback;
        }
#pragma warning restore CS1591 // Fehlendes XML-Kommentar fr ffentlich sichtbaren Typ oder Element

        /// <summary>
        /// Get information about a subscription
        /// </summary>
        public override IActionResult GetSubscription([FromRoute(Name = "subscriptionUUID")][Required] Guid subscriptionUUID, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // todo: search for a subscription and send it back
            foreach (var item in m_subscriptionsPoses)
            {
                if (item.Key == subscriptionUUID)
                {
                    SubscriptionSingle response = new SubscriptionSingle();
                    response.Uuid = subscriptionUUID;
                    response.Target = item.Value.subscription.Target;
                    response.Mode = item.Value.pose.Mode;
                    response.Validity = item.Value.timeValidity.Millisecond;
                    response.WebhookUrl = item.Value.subscription.WebhookUrl;
                    response.WebsocketUrl = item.Value.webSocket;
                    return new ObjectResult(response);
                }
            }
            return StatusCode(404, new Error() { Message = "Not found." });
        }

        /// <summary>
        /// Subscribe to collect the pose of an AR device, an Anchor or a Trackable
        /// </summary>
        public override IActionResult SubscribeToPose([FromBody] SubscribeToPoseRequest subscribeToPoseRequest, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            // Simulation ON for STF669 pose calcualtion
            string _token = token;
            Guid parentUUID = Guid.Empty;
            if (token.Contains(","))
            {
                _token = token.Split(',')[0];
                parentUUID = new Guid(token.Split(',')[1]);
            }

            if (!Startup.IsAccessGranted(_token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            if (subscribeToPoseRequest.Targets != null && subscribeToPoseRequest.Targets.Count > 0)
            {
                return StatusCode(404, "Multiple subscriptions are not implemented (targets).");
            }
            else if (subscribeToPoseRequest.Modes != null && subscribeToPoseRequest.Modes.Count > 0)
            {
                return StatusCode(404, "Multiple subscriptions are not implemented (modes).");
            }

            int validity = subscribeToPoseRequest.Validity; // todo: is to handle here or by the client?

            SubscribeToPose200Response response = new SubscribeToPose200Response();
            response.Validity = validity;
            response.Uuid = Guid.NewGuid();
            response.Target = subscribeToPoseRequest.Target;
            response.Mode = subscribeToPoseRequest.Mode;
            response.WebhookUrl = subscribeToPoseRequest.WebhookUrl;
            response.WebsocketUrl = "";

            // Send the websocket connection URL
            if (string.IsNullOrEmpty(response.WebhookUrl))
            {
                // Notice: starting websocket server is done autom. by the client, when calling "URL:xxx/ws"
                // Registering the client is done in the analysis module, so the websocket can send to it pose updates
                response.WebsocketUrl = "wss://" + Request.Host.ToString() + "/ws";
            }

            // We add the subscription
            SubscriptionInfo info = new SubscriptionInfo();
            info.uuidSub = response.Uuid;
            info.webSocket = response.WebsocketUrl;
            info.timeValidity = DateTime.Now.AddMilliseconds(validity / 1000.0f);

            info.pose = new Pose();
            info.pose.Mode = response.Mode;

            info.subscription = new SubscribeToPoseRequest();
            info.subscription.Target = response.Target;
            info.subscription.Mode = response.Mode;
            info.subscription.Validity = response.Validity;
            info.subscription.WebhookUrl = response.WebhookUrl;

            m_subscriptionsPoses.Add(info.uuidSub, info);

            // todo: inform the module(s) that the client will track an anchor/trackable and need the pose
            // todo: has the module to call GetRelocalizationInformation() then?!?
            WorldAnalysisConnections.Singleton.SubscribeToPose(info, parentUUID);

            return new ObjectResult(response);
        }

        /// <summary>
        /// Remove a subscription to a given pose
        /// </summary>
        public override IActionResult UnsubscribeFromPose([FromRoute(Name = "subscriptionUUID")][Required] Guid subscriptionUUID, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // Remove the subscription from the list?
            if (m_subscriptionsPoses.ContainsKey(subscriptionUUID)) m_subscriptionsPoses.Remove(subscriptionUUID);
            else
            {
                //return StatusCode(404, new Error() { Message = "Unsubscribe UUID not found!" });
            }

            // Inform the module(s) that the subscription ended
            WorldAnalysisConnections.Singleton.UnsubscribeFromPose(subscriptionUUID);

            return StatusCode(200, new Success() { Message = "Unsubscription successfull." });
        }

        /// <summary>
        /// Update a subscription
        /// </summary>
        public override IActionResult UpdateSubscription([FromRoute(Name = "subscriptionUUID")][Required] Guid subscriptionUUID, [FromBody] UpdateSubscriptionRequest updateSubscriptionRequest, [FromHeader(Name = "token")] string token, [FromHeader(Name = "sessionID")] string sessionID)
        {
            if (!Startup.IsAccessGranted(token)) return StatusCode(511, new Error() { Message = "Invalid token!" });

            // todo: compare sessionID

            // todo: inform the module(s) that the subscription changed

            return StatusCode(405, new Error() { Message = "Not supported yet!" });
        }
    }
}
