﻿using ETSI.ARF.OpenAPI.WorldAnalysis.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using static ETSI.ARF.OpenAPI.WorldAnalysis.Controllers.PoseApiControlleImpl;
using ETSI.ARF.OpenAPI.WorldAnalysis.Controllers;

#pragma warning disable CS1591 // Fehlendes XML-Kommentar für öffentlich sichtbaren Typ oder Element
namespace ETSI.ARF.OpenAPI.WorldAnalysis
{
    // For management of WA modules
    public class Module
    {
        public string name;
        public List<Capability> capabilities = new List<Capability>();
        public WebSocketController websockets;
    }

    // For management of WA clinet (e.g. Unity client)
    public class Client
    {
        public string name;
        public string session;
        public WebSocketController websockets;
    }

    public class WorldAnalysisModules
    {
        static public WorldAnalysisModules Singleton = new WorldAnalysisModules();

        public List<Module> modules = new List<Module>();
        public List<Client> clients = new List<Client>();

        // todo
        // Manage the sessions and modules
        // get capabilities of all modules
        public List<Capability> GetCapabilities()
        {
            List<Capability> list = new List<Capability>();
            foreach (var item in modules)
            {
                list.AddRange(item.capabilities);
            }
            return list;
        }

        public List<Capability> GetCapabilitiesFromUuid(Guid trackableOrAnchorUUID)
        {
            List<Capability> list = new List<Capability>();
            foreach (var item in modules)
            {
                // todo: Check if uuid has the capability?
                // Get the world object from the world storage via the module?
                // Use GetRelocalisation() ?
                list.AddRange(item.capabilities);
            }
            return list;
        }

        public void ConfigureFramerate(PoseConfiguration poseConfiguration)
        {
            foreach (var item in modules)
            {
                // todo: configure the module via websocket
                item.websockets.SendText("ConfigureFramerate:" + poseConfiguration.ToJson());
            }
        }

        public Pose GetPose(Guid trackableOrAnchorUUID, ModeWorldAnalysis mode)
        {
            Pose result = new Pose();
            foreach (var item in modules)
            {
                // todo: get the pose via websocket
                item.websockets.SendText("GetPose:" + trackableOrAnchorUUID + ":" + mode.ToString());

                // todo: find the pose with the best confidence?
                // How to get the results !?!?! (List with results, per Modules)
            }
            return result;
        }


        public void SubscribeToPose(SubscriptionInfo info)
        {
            // Send to all modules a request of subscription
            foreach (var item in modules)
            {
                item.websockets.SendText("SubscribePose:" + info.uuidTarget.ToString());
            }
        }

        public void UnsubscribeFromPose(Guid uuid)
        {
            // Send to all modules a request of subscription
            foreach (var item in modules)
            {
                item.websockets.SendText("UnsubscribePose:" + uuid.ToString());
            }
        }

        public void SendPoseToClients(Pose p)
        {
            // Send to all clients with valid subscription the new pose
            foreach (var item in clients)
            {
                item.websockets.SendText("Pose=" + p.ToJson());
            }
        }
    }
}
#pragma warning restore CS1591 // Fehlendes XML-Kommentar für öffentlich sichtbaren Typ oder Element
