//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

/*
 * World Analysis API
 *
 * API ensuring interoperability between Scene Management and a World Analysis service
 *
 * The version of the OpenAPI document: 2.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldAnalysis.Attributes;
using ETSI.ARF.OpenAPI.WorldAnalysis.Models;

namespace ETSI.ARF.OpenAPI.WorldAnalysis.Controllers
{ 
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class CapabilitiesApiControllerImpl : CapabilitiesApiController
    { 
        /// <summary>
        /// Get the supported capabilities of the World Analysis
        /// </summary>
        public override IActionResult GetCapabilities([FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            // Get all capabilities from all anchors/trackables
            // test
            Capability capability = new Capability();
            capability.Framerate = 24;
            capability.Latency = 0;
            capability.TrackableType = TrackableType.FIDUCIALMARKEREnum;

            // Create list
            List<Capability> capabilities = new List<Capability>();
            capabilities.Add(capability);

            // Create repsonse object
            GetCapabilities200Response response = new GetCapabilities200Response();
            response.Capabilities = capabilities;
            return new ObjectResult(response);
            //return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// For a given trackable or anchor, get its support information
        /// </summary>
        public override IActionResult GetSupport([FromRoute (Name = "trackableOrAnchorUUID")][Required]Guid trackableOrAnchorUUID, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            Capability capability = new Capability();
            capability.Framerate = 24;
            capability.Latency = 0;
            capability.TrackableType = TrackableType.FIDUCIALMARKEREnum;
            return (null != capability) ? new ObjectResult(capability) : StatusCode(404, "Not found, could not find capability for UUID: " + trackableOrAnchorUUID);
            //return StatusCode(405, "Not supported yet!");
        }
    }
}
