//
// ARF - Augmented Reality Framework (ETSI ISG ARF)
//
// Copyright 2024 ETSI
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Last change: June 2024
//

/*
 * World Analysis API
 *
 * API ensuring interoperability between Scene Management and a World Analysis service
 *
 * The version of the OpenAPI document: 2.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */

using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http;
using Swashbuckle.AspNetCore.Annotations;
using Swashbuckle.AspNetCore.SwaggerGen;
using Newtonsoft.Json;
using ETSI.ARF.OpenAPI.WorldAnalysis.Attributes;
using ETSI.ARF.OpenAPI.WorldAnalysis.Models;

namespace ETSI.ARF.OpenAPI.WorldAnalysis.Controllers
{ 
    /// <summary>
    /// 
    /// </summary>
    [ApiController]
    public class PoseApiControlleImpl : PoseApiController
    { 
        /// <summary>
        /// Specify the a minimum frame rate for pose estimation for Trackable types
        /// </summary>
        public override IActionResult ConfigureFramerate([FromBody]PoseConfiguration poseConfiguration, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Request the last pose of a single Anchor or Trackable
        /// </summary>
        public override IActionResult GetPose([FromRoute (Name = "trackableOrAnchorUUID")][Required]Guid trackableOrAnchorUUID, [FromQuery (Name = "mode")][Required()]ModeWorldAnalysis mode, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Request the last pose of a batch of Anchor or Trackable
        /// </summary>
        public override IActionResult GetPoses([FromQuery (Name = "uuid")][Required()]List<GetPosesUuidParameterInner> uuid, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Get information about a subscription
        /// </summary>
        public override IActionResult GetSubscription([FromRoute (Name = "subscriptionUUID")][Required]Guid subscriptionUUID, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Subscribe to collect the pose of an AR device, an Anchor or a Trackable
        /// </summary>
        public override IActionResult SubscribeToPose([FromBody]SubscribeToPoseRequest subscribeToPoseRequest, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Remove a subscription to a given pose
        /// </summary>
        public override IActionResult UnsubscribeFromPose([FromRoute (Name = "subscriptionUUID")][Required]Guid subscriptionUUID, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }

        /// <summary>
        /// Update a subscription
        /// </summary>
        public override IActionResult UpdateSubscription([FromRoute (Name = "subscriptionUUID")][Required]Guid subscriptionUUID, [FromBody]UpdateSubscriptionRequest updateSubscriptionRequest, [FromHeader (Name = "token")]string token, [FromHeader (Name = "sessionID")]string sessionID)
        {
            return StatusCode(405, "Not supported yet!");
        }
    }
}
