﻿using ETSI.ARF.OpenAPI.WorldAnalysis.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

#pragma warning disable CS1591 // Fehlendes XML-Kommentar für öffentlich sichtbaren Typ oder Element
namespace ETSI.ARF.OpenAPI.WorldAnalysis
{
    // For management of WA modules
    public class Module
    {
        public string name;
        public List<Capability> capabilities = new List<Capability>();
    }

    // For management of WA clinet (e.g. Unity client)
    public class Client
    {
        public string name;
        public string session;

    }

    public class WorldAnalysisModules
    {
        static public WorldAnalysisModules Singleton = new WorldAnalysisModules();

        public List<Module> modules = new List<Module>();
        public List<Client> clients = new List<Client>();

        // todo
        // Manage the sessions and modules
        // get capabilities of all modules
        public List<Capability> GetCapabilities()
        {
            List<Capability> list = new List<Capability>();
            foreach (var item in modules)
            {
                list.AddRange(item.capabilities);
            }
            return list;
        }
    }
}
#pragma warning restore CS1591 // Fehlendes XML-Kommentar für öffentlich sichtbaren Typ oder Element
