using UnityEngine;

public class RayCastSelection : MonoBehaviour
{
    void Update()
    {
        if (Input.GetMouseButtonDown(0) || (Input.touchCount > 0 && Input.GetTouch(0).phase == TouchPhase.Began))
        {
            Raycast();
        }
    }

    void Raycast()
    {
        Ray ray;

        // Determine if it's a mouse click or touch
        if (Input.touchCount > 0)
        {
            ray = Camera.main.ScreenPointToRay(Input.GetTouch(0).position);
        }
        else
        {
            ray = Camera.main.ScreenPointToRay(Input.mousePosition);
        }

        RaycastHit hit;

        if (Physics.Raycast(ray, out hit))
        {
            // Add your logic here for what happens when the raycast hits an object
             hit.collider.gameObject.SendMessage("Interact", SendMessageOptions.DontRequireReceiver);
        }
    }
}
