using Unity.VisualScripting;
using UnityEditor;
using UnityEngine;

public class ARSceneCreator 
{
    
    [MenuItem("ARF/Create AR Scene")]
    static void CreateARScene()
    {
        GameObject obj = GameObject.Find("ARF Visuals");

        if (obj != null)
        {
            GameObject arScene = new GameObject("ARScene");
            
            foreach(Transform trackableOrAnchor in obj.transform)
            {
                if (trackableOrAnchor.childCount > 2)
                {
                    // go through all nodes (trackable or anchor)
                    GameObject node = new GameObject(trackableOrAnchor.name);
                    node.transform.parent = arScene.transform ;
                    AnchorTrackableReferenceNode referenceWA = node.AddComponent<AnchorTrackableReferenceNode>() ;
                    referenceWA._ARFNodeUUID = trackableOrAnchor.name ;
                    foreach(Transform asset in trackableOrAnchor)
                    {
                        if (asset.gameObject.name != "Axe" && asset.gameObject.name != "Canvas")
                        {
                            GameObject copyAsset = GameObject.Instantiate(asset.gameObject);
                            copyAsset.transform.parent = node.transform ;
                            copyAsset.transform.localPosition = asset.transform.localPosition; 
                            copyAsset.transform.localRotation = asset.transform.localRotation;
                            copyAsset.transform.localScale = asset.transform.localScale; 
                            asset.gameObject.SetActive(false);
                        }
                    }
                }
            }
        }
        else 
        {
            Debug.Log("No ARF Visuals: can't create AR Scene");
        }
    }
}
