using UnityEngine;

/// <summary>
/// Factory for instantiating different types of WA
/// </summary>
public class WorldAnalysisFactory
{
    [System.Serializable]
    public enum WorldAnalysisType
    {
        LOCAL,
        REST
    }

    public static WorldAnalysisInterface CreateWorldAnalysis(WorldAnalysisType type, GameObject obj)
    {
        if (type == WorldAnalysisType.LOCAL)
        {
            return obj.AddComponent<WorldAnalysisARFoundation>();
        }
        else if (type == WorldAnalysisType.REST)
        {
            return obj.AddComponent <WorldAnalysisREST>();
        }
        return null; 
    }
}