using UnityEngine;

/// <summary>
/// Create a WA instance into the scene based on a type
/// </summary>
public class WorldAnalysisInstance : MonoBehaviour
{
    /// <summary>
    /// Types of World Analysis to Use
    /// </summary>
    public WorldAnalysisFactory.WorldAnalysisType _WorldAnalysisType;

    /// <summary>
    /// The token to use for the REST request
    /// </summary>
    static public string token = "dev";

    /// <summary>
    /// The sessionID to use for the REST request
    /// </summary>
    static public string sessionID = "ARF-STF669";

    // Start is called before the first frame update
    protected void Awake()
    {
        if (_WorldAnalysisType != WorldAnalysisFactory.WorldAnalysisType.MANUAL) WorldAnalysisFactory.CreateWorldAnalysis(_WorldAnalysisType, this.gameObject);
    }
}