using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using WebSocketSharp;

using ETSI.ARF.WorldAnalysis;
using ETSI.ARF.WorldAnalysis.REST;
using ETSI.ARF.OpenAPI.WorldAnalysis;
using Pose = ETSI.ARF.OpenAPI.WorldAnalysis.Pose;
using UnityEngine.InputSystem;
using System;
using static WorldAnalysisInterface;

public class ClientTest : MonoBehaviour
{
    static public string token = "ARF_Permission";
    static public string session = "HHI";

    public WorldAnalysisREST rest;
    public GameObject asset1;

    
    // Start is called before the first frame update
    void Start()
    {
        if (asset1 != null) asset1.GetComponent<Renderer>().material.color = Color.red;

        rest.CheckServer();
        Capability[] caps;
        if (rest.GetCapabilities(token, out caps) == WorldAnalysisInterface.CapabilityResult.OK)
        {
            rest.PrintCapabilities(caps);
        }

        int validity = 0;
        Guid subs;
        Guid anchor = Guid.Parse("fa8bbe40-8052-11ec-a8a3-0242ac120002");
        
        rest.SubscribeToPose(token, anchor, Mode_WorldAnalysis.TRACKABLES_TO_DEVICE, PoseCallback, ref validity, out subs);
    }

    // Update is called once per frame
    bool updateAsset1 = false;
    Color asset1Color = Color.grey;
    void Update()
    {
        if (Keyboard.current.spaceKey.wasPressedThisFrame)
        {
            //webSocket.Send("PoseStart:10");
        }

        if (updateAsset1)
        {
            updateAsset1 = false;
            asset1.GetComponent<Renderer>().material.color = asset1Color;
        }
    }

    void SetColor(Color c)
    {
        updateAsset1 = true;
        asset1Color = c;
    }

    public void SubscribeToPose()
    {
        Guid uuid = new Guid(); // request id from anchor or trackable
        Guid subId;
        int validity = 1;

        InformationSubscriptionResult response = rest.SubscribeToPose(token, uuid, Mode_WorldAnalysis.TRACKABLES_TO_DEVICE, PoseCallback, ref validity, out subId);
        if (response == InformationSubscriptionResult.OK)
        {
            // State: yellow
        }
    }

    public void PoseCallback(WorldAnalysisInterface.PoseEstimationResult result, ETSI.ARF.OpenAPI.WorldAnalysis.Pose pose)
    {
        switch (result)
        {
            case PoseEstimationResult.OK:
                // State: green
                //asset1.transform.rotation = WorldAnalysisUnityHelper.ConvertETSIARFQuaternionToUnity(pose.Value.ro...)
                break;
            
            case PoseEstimationResult.NONE:
                // State: yellow
                break;
            
            case PoseEstimationResult.NOT_ALLOWED:
                // State: red
                break;
            
            case PoseEstimationResult.FAILURE:
                // State: red
                break;
            
            case PoseEstimationResult.NOT_SUPPORTED:
                // State: red
                break;
            
            case PoseEstimationResult.UNKNOWN_ID:
                // State: red
                break;
        }
    }
}
