*This repository is part of the outcomes of the Specialist Task Force 669 focusing on the World Analysis as part of the ETSI ISG Augmented Reality Framework architecture (https://www.etsi.org/deliver/etsi_gs/ARF/001_099/003/01.01.01_60/gs_ARF003v010101p.pdf).*
*The set of the World Anlysis components includes:*

*•	The C++ and C# source code for servers and clients  generated from OpenAPI available here (https://forge.etsi.org/rep/arf/openapi)*

*•	Multiple Unity plugin (wrappers) implementing the World Analysis with various AR technologies

*All these components are available under the ETSI Labs group “World Analysis API Helpers”:  https://labs.etsi.org/rep/arf/world-analysis-api-helpers*

*This repository and the associated components depend on the World Storage components developed in the context of the Specialist Task Force 620 that focused on the authoring of a World Representation and which are vailable under the ETSI Labs group “World Storage API Helpers”: https://labs.etsi.org/rep/arf/world-storage-api-helpers*

*If you wish to contribute to this project or any other projects in the context of the [ETSI ISG Augmented Reality Framework architecture](https://www.etsi.org/committee/1420-arf), please refer to the ["How to get involved in an ISG" section on the ETSI website](https://www.etsi.org/how-to-get-involved-in-an-isg)*

---

## Setting Unity Packages

This repo contains submodules corresponding to REST libraries and wrappers used in the Unity project.

Once the git repo is cloned, you need to init and update the submodules through git commands:

    git submodule init
    git submodule update

or clone the repos updating the submodules directly:

    git clone --recurse-submodules https://labs.etsi.org/rep/arf/world-storage-api-helpers/unity-world-storage-editor.git

Once it's done, you can open your project from the Unity Hub, the project was developed with Unity 2022.3


## World Storage Editor 

The WS Editor is responsible for editing the World Graph with the Trackables and World Anchors to which the AR content will be attached.

To edit the World Storage use a World Storage Server Asset and then "Open World Storage Window" to access the server and then "Open World Representation Graph Window" to open the graph view.

An example of server is available at https://etsi.hhi.fraunhofer.de and accessible through a dedicated asset in .\Assets\ISG-ARF\Resources\WS.ARFWorldStorageServer HHI


## World Analysis

The WA is responsible to compute the poses of the AR Scene nodes in reference to the real world at runtime.

Two types of WA are available.
* LOCAL_ARFOUNDATION corresponds to WA that runs locally based on Unity ARFoundation (ARKit on iOS and ARCore on Android)
* REST corresponds to a remote WA. Examples of implementation include the spatial computing platforms from HHI or b<>com SolAR solution. Please contact them for additional information and for testing.

To choose a given one use the WorldAnalysisInstance script on the ARFWorldAnalysis GameObject.

For a local WA, the information about the WS to retrieve Relocalization Information in a WorldStorageServer ScriptableObject assigned to the WorldStorageInfo script on the ARFWorldStorageInfo GameObject. This ScriptableObject specifies the URL of the WS server.

A GameObject of the Unity Scene graph can be associated with a node (Trackable or WorldAnchor) of the World Storage with the AnchorTrackableReferenceNode script. You just have to associate the script with a given GameObject and specify the WS uuid of the corresponding Trackable or WorldAnchor.


## Samples

### Server Maintenance

The repository includes examples on how to use the WS and WA components to develop a Unity application in the context of a data center server guidance and maintenance and use case.
This use case has been adapted respectively by Orange (see .\Assets\ISG-ARF\Orange_Application) and the HHI (see .\Assets\ISG-ARF\HHI_Application). These applications are dedicated to specific physical places and are dependent to specific World Storage instances.
Please contact them to have more information about how to adapt this use case to different places.


### glTF Player

To demonstrate simple examples the respository includes a sample based on the glTF format

The sample can be found in
	.\Assets\ISG-ARF\Common_Application\ExampleGLTF
	
The scene loads a GLTF file situated in the Unity persistent data path (streaming assets path in editor mode). Any node with the following pattern name: ws:"uuid" will correspond to an Anchor or Trackable in the World Storage and then will be updated by the loaded World Analysis wrapper.
As an example, based on the provided HHI server, ARSceneOneAnchor.glb found in the StreamingAssets can displayed on top of the following image : https://www.dropbox.com/scl/fi/jlswlf0rhgha3pfbf76ft/graf.png?rlkey=z3rtcvuzgl9m2k7s8td8kl2ls&st=a178iuvt&dl=0 (A4 format)